/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.serialize.protostuff;

import cn.sliew.milky.serialize.DataOutputView;
import cn.sliew.milky.serialize.protostuff.Wrapper;
import cn.sliew.milky.serialize.protostuff.utils.WrapperUtils;
import io.protostuff.GraphIOUtil;
import io.protostuff.LinkedBuffer;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ProtostuffDataOutputView
implements DataOutputView {
    private LinkedBuffer buffer = LinkedBuffer.allocate();
    private DataOutputStream dos;

    public ProtostuffDataOutputView(OutputStream outputStream) {
        this.dos = new DataOutputStream(outputStream);
    }

    @Override
    public void write(int b) throws IOException {
        this.dos.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.dos.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.dos.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.dos.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.dos.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.dos.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.dos.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.dos.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.dos.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.dos.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.dos.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.dos.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.dos.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.dos.writeUTF(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(Object obj) throws IOException {
        byte[] classNameBytes;
        byte[] bytes;
        try {
            if (obj == null || WrapperUtils.needWrapper(obj)) {
                Schema schema = RuntimeSchema.getSchema(Wrapper.class);
                Wrapper<Object> wrapper = new Wrapper<Object>(obj);
                bytes = GraphIOUtil.toByteArray(wrapper, (Schema)schema, (LinkedBuffer)this.buffer);
                classNameBytes = Wrapper.class.getName().getBytes();
            } else {
                Schema schema = RuntimeSchema.getSchema(obj.getClass());
                bytes = GraphIOUtil.toByteArray((Object)obj, (Schema)schema, (LinkedBuffer)this.buffer);
                classNameBytes = obj.getClass().getName().getBytes();
            }
        }
        finally {
            this.buffer.clear();
        }
        this.dos.writeInt(classNameBytes.length);
        this.dos.writeInt(bytes.length);
        this.dos.write(classNameBytes);
        this.dos.write(bytes);
    }

    @Override
    public void flushBuffer() throws IOException {
        this.dos.flush();
    }
}

