package cn.sparrowmini.common.restapi;

import java.util.List;
import java.util.Set;

import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import cn.sparrowmini.common.CommonProp;

public interface BaseJpaService<T extends CommonProp, ID> {
//	@PostMapping("")
//	@ResponseBody
//	@ResponseStatus(code = HttpStatus.CREATED)
//	@Operation(summary = "创建")
	public ApiResponse<ID> create(@RequestBody T entity);
	
//	@PostMapping("/submit")
//	@ResponseBody
//	@ResponseStatus(code = HttpStatus.CREATED)
//	@Operation(summary = "创建并提交")
	public ApiResponse<ID> submit(@RequestBody T entity);
	
//	@PostMapping("/batch")
//	@ResponseBody
//	@ResponseStatus(code = HttpStatus.CREATED)
//	@Operation(summary = "批量创建")
	public void batchCreate(@RequestBody List<T> entities);

//	@GetMapping("/{id}")
//	@ResponseBody
//	@Operation(summary = "详情")
	public T get(@PathVariable ID id);

//	@PatchMapping("/{id}")
//	@ResponseBody
//	@Operation(summary = "更新")
//	@ResponseStatus(code = HttpStatus.NO_CONTENT)
	public void update(@PathVariable ID id, @RequestBody T entity);

//	@DeleteMapping("")
//	@ResponseBody
//	@Operation(summary = "删除")
//	@ResponseStatus(code = HttpStatus.NO_CONTENT)
	public void delete(@RequestBody Set<ID> ids);

//	@GetMapping("")
//	@ResponseBody
//	@Operation(summary = "列表")
	public Page<T> list(@ParameterObject Pageable pageable, @Nullable @ParameterObject @RequestParam T filter);

//	@PatchMapping("/{id}/status")
//	@ResponseBody
//	@Operation(summary = "更新状态")
//	@ResponseStatus(code = HttpStatus.NO_CONTENT)
	public void updateStatus(@PathVariable ID id, @Nullable @RequestParam String status,
			@Nullable @RequestParam Boolean enabled);
}
