package cn.sparrowmini.common.restapi.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

import org.reflections.ReflectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

import cn.sparrowmini.common.CommonProp;
import cn.sparrowmini.common.restapi.ApiResponse;
import cn.sparrowmini.common.restapi.BaseJpaService;
import cn.sparrowmini.common.restapi.CommonStatEnum;

@MappedSuperclass
public abstract class BaseJpaServiceImpl<T extends CommonProp, ID> implements BaseJpaService<T, ID> {
	@Autowired
	private JpaRepository<T, ID> jpaRepository;

	@Override
	public ApiResponse<ID> create(T entity) {
		T t = this.jpaRepository.save(entity);
		Set<Field> fields = ReflectionUtils.getFields(t.getClass(), ReflectionUtils.withAnnotation(Id.class));

		if (fields.size() == 0) {
			fields = ReflectionUtils.getFields(t.getClass(), ReflectionUtils.withAnnotation(EmbeddedId.class));
		}
		for (Field field : fields) {
			try {
				field.setAccessible(true);
				field.get(t);
				return new ApiResponse<ID>().success((ID) field.get(t));
			} catch (IllegalAccessException e) {
				throw new RuntimeException(e);
			}
		}
		return null;

	}

	@Override
	public ApiResponse<ID> submit(T entity) {
		entity.setStat(CommonStatEnum.Submitted.name());
		T t = this.jpaRepository.save(entity);
		t.setStat(CommonStatEnum.Submitted.name());
		Set<Field> fields = ReflectionUtils.getFields(t.getClass(), ReflectionUtils.withAnnotation(Id.class));

		if (fields.size() == 0) {
			fields = ReflectionUtils.getFields(t.getClass(), ReflectionUtils.withAnnotation(EmbeddedId.class));
		}
		for (Field field : fields) {
			try {
				field.setAccessible(true);
				field.get(t);
				return new ApiResponse<ID>().success((ID) field.get(t));
			} catch (IllegalAccessException e) {
				throw new RuntimeException(e);
			}
		}
		return null;

	}

	@Override
	public void batchCreate(List<T> entity) {
		this.jpaRepository.saveAll(entity);
	}

	@Override
	public T get(ID id) {
		return this.jpaRepository.findById(id).get();
	}

	@Override
	public void update(ID id, T entity) {
		T ref = this.jpaRepository.getById(id);
		BeanUtils.copyProperties(entity, ref, "id");
		this.jpaRepository.save(ref);

	}

	@Override
	public void delete(Set<ID> ids) {
		this.jpaRepository.deleteAllById(ids);
	}

	@Override
	public Page<T> list(Pageable pageable, T filter) {
		if (filter != null) {
			return this.jpaRepository.findAll(Example.of(filter), pageable);
		} else {
			return this.jpaRepository.findAll(pageable);
		}
	}

	@Override
	public void updateStatus(ID id, String status, Boolean enabled) {
		T ref = this.jpaRepository.getById(id);
		if (status != null) {
			ref.setStat(status);
		}

		if (enabled != null) {
			ref.setEnabled(enabled);
		}
		this.jpaRepository.save(ref);
	}

	private static Field[] getAnnotatedDeclaredFields(Class clazz, Class<? extends Annotation> annotationClass,
			boolean recursively) {
		Field[] allFields = getDeclaredFields(clazz, recursively);
		List<Field> annotatedFields = new LinkedList<Field>();

		for (Field field : allFields) {
			if (field.isAnnotationPresent(annotationClass))
				annotatedFields.add(field);
		}

		return annotatedFields.toArray(new Field[annotatedFields.size()]);
	}

	private static Field[] getDeclaredFields(Class clazz, boolean recursively) {
		List<Field> fields = new LinkedList<Field>();
		Field[] declaredFields = clazz.getDeclaredFields();
		Collections.addAll(fields, declaredFields);

		Class superClass = clazz.getSuperclass();

		if (superClass != null && recursively) {
			Field[] declaredFieldsOfSuper = getDeclaredFields(superClass, recursively);
			if (declaredFieldsOfSuper.length > 0)
				Collections.addAll(fields, declaredFieldsOfSuper);
		}

		return fields.toArray(new Field[fields.size()]);
	}

}
