/*
 * Decompiled with CFR 0.152.
 */
package cn.springcloud.gray.client.gateway;

import cn.springcloud.gray.RequestInterceptor;
import cn.springcloud.gray.request.GrayHttpTrackInfo;
import cn.springcloud.gray.request.GrayRequest;
import cn.springcloud.gray.request.GrayTrackInfo;
import cn.springcloud.gray.request.HttpGrayTrackRecordDevice;
import cn.springcloud.gray.request.HttpGrayTrackRecordHelper;
import java.util.List;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class GatewayRequestInterceptor
implements RequestInterceptor {
    public String interceptroType() {
        return "gateway";
    }

    public boolean shouldIntercept() {
        return true;
    }

    public boolean pre(GrayRequest request) {
        GrayHttpTrackInfo grayTrack = (GrayHttpTrackInfo)request.getGrayTrackInfo();
        if (grayTrack != null) {
            ServerHttpRequest.Builder requestBuilder = (ServerHttpRequest.Builder)request.getAttribute("gateway.httpRequest.builder");
            HttpGrayTrackRecordHelper.record((HttpGrayTrackRecordDevice)new GatewayHttpGrayTrackRecordDevice(requestBuilder), (GrayTrackInfo)grayTrack);
        }
        return true;
    }

    public boolean after(GrayRequest request) {
        return true;
    }

    public static class GatewayHttpGrayTrackRecordDevice
    implements HttpGrayTrackRecordDevice {
        private ServerHttpRequest.Builder requestBuilder;

        public GatewayHttpGrayTrackRecordDevice(ServerHttpRequest.Builder requestBuilder) {
            this.requestBuilder = requestBuilder;
        }

        public void record(String name, String value) {
            this.requestBuilder.header(name, value);
        }

        public void record(String name, List<String> values) {
            for (String v : values) {
                this.requestBuilder.header(name, v);
            }
        }
    }
}

