/*
 * Decompiled with CFR 0.152.
 */
package cn.springcloud.gray.client.gateway;

import cn.springcloud.gray.client.config.properties.GrayRequestProperties;
import cn.springcloud.gray.request.GrayHttpRequest;
import cn.springcloud.gray.request.GrayRequest;
import cn.springcloud.gray.request.GrayTrackInfo;
import cn.springcloud.gray.request.RequestLocalStorage;
import cn.springcloud.gray.routing.connectionpoint.RoutingConnectPointContext;
import cn.springcloud.gray.routing.connectionpoint.RoutingConnectionPoint;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

@Deprecated
public class GrayGlobalFilter
implements GlobalFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(GrayGlobalFilter.class);
    public static final String GRAY_REQUEST_ATTRIBUTE_GATEWAY_HTTPREQUEST_BUILDER = "gateway.httpRequest.builder";
    protected Integer filterOrder = 10010;
    private GrayRequestProperties grayRequestProperties;
    private RoutingConnectionPoint routingConnectionPoint;
    private RequestLocalStorage requestLocalStorage;

    public GrayGlobalFilter(GrayRequestProperties grayRequestProperties, RoutingConnectionPoint routingConnectionPoint, RequestLocalStorage requestLocalStorage) {
        this.grayRequestProperties = grayRequestProperties;
        this.routingConnectionPoint = routingConnectionPoint;
        this.requestLocalStorage = requestLocalStorage;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        String schemePrefix = (String)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_SCHEME_PREFIX_ATTR);
        URI url = (URI)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        if (url == null || !"lb".equals(url.getScheme()) && !"lb".equals(schemePrefix)) {
            return chain.filter(exchange);
        }
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        GrayHttpRequest grayRequest = new GrayHttpRequest();
        grayRequest.setUri(serverHttpRequest.getURI());
        grayRequest.setServiceId(url.getHost().toLowerCase());
        grayRequest.addParameters((Map)serverHttpRequest.getQueryParams());
        if (this.grayRequestProperties.isLoadBody()) {
            grayRequest.setBody(((DataBuffer)serverHttpRequest.getBody().blockFirst()).asByteBuffer().array());
        }
        grayRequest.setMethod(serverHttpRequest.getMethodValue());
        HttpHeaders headers = new HttpHeaders();
        headers.addAll((MultiValueMap)serverHttpRequest.getHeaders());
        grayRequest.setHeaders((Map)headers);
        ServerHttpRequest.Builder requestBuilder = exchange.getRequest().mutate();
        grayRequest.setAttribute(GRAY_REQUEST_ATTRIBUTE_GATEWAY_HTTPREQUEST_BUILDER, (Object)requestBuilder);
        this.recordGrayTrack(exchange);
        RoutingConnectPointContext connectPointContext = RoutingConnectPointContext.builder().interceptroType("gateway").grayRequest((GrayRequest)grayRequest).build();
        this.routingConnectionPoint.executeConnectPoint(connectPointContext);
        ServerHttpRequest newRequest = requestBuilder.build();
        ServerWebExchange newExchange = exchange.mutate().request(newRequest).build();
        return chain.filter(newExchange).doFinally(t -> this.destoryRequestLocal((SignalType)t, connectPointContext));
    }

    private void recordGrayTrack(ServerWebExchange exchange) {
        GrayTrackInfo grayTrackInfo;
        if (this.requestLocalStorage.getGrayTrackInfo() == null && (grayTrackInfo = (GrayTrackInfo)exchange.getAttributes().get("GrayWebTrack")) != null) {
            this.requestLocalStorage.setGrayTrackInfo(grayTrackInfo);
        }
    }

    private void destoryRequestLocal(SignalType t, RoutingConnectPointContext connectPointContext) {
        this.routingConnectionPoint.shutdownconnectPoint(connectPointContext);
        this.requestLocalStorage.removeGrayTrackInfo();
    }

    public int getOrder() {
        return this.filterOrder;
    }
}

