/*
 * Decompiled with CFR 0.152.
 */
package cn.springcloud.gray.client.gateway;

import cn.springcloud.gray.client.config.properties.GrayRequestProperties;
import cn.springcloud.gray.request.GrayHttpRequest;
import cn.springcloud.gray.request.GrayRequest;
import cn.springcloud.gray.request.GrayTrackInfo;
import cn.springcloud.gray.request.RequestLocalStorage;
import cn.springcloud.gray.routing.connectionpoint.RoutingConnectPointContext;
import cn.springcloud.gray.routing.connectionpoint.RoutingConnectionPoint;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.LoadBalancerClientFilter;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GrayLoadBalancerClientFilter
extends LoadBalancerClientFilter {
    private static final Logger log = LoggerFactory.getLogger(GrayLoadBalancerClientFilter.class);
    public static final String GRAY_REQUEST_ATTRIBUTE_GATEWAY_HTTPREQUEST_BUILDER = "gateway.httpRequest.builder";
    @Autowired
    private GrayRequestProperties grayRequestProperties;
    @Autowired
    private RoutingConnectionPoint routingConnectionPoint;
    @Autowired
    private RequestLocalStorage requestLocalStorage;

    public GrayLoadBalancerClientFilter(LoadBalancerClient loadBalancer) {
        super(loadBalancer);
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        String overrideScheme;
        URI url = (URI)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String schemePrefix = (String)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_SCHEME_PREFIX_ATTR);
        if (url == null || !"lb".equals(url.getScheme()) && !"lb".equals(schemePrefix)) {
            return chain.filter(exchange);
        }
        ServerWebExchangeUtils.addOriginalRequestUrl((ServerWebExchange)exchange, (URI)url);
        log.trace("LoadBalancerClientFilter url before: " + url);
        ServerHttpRequest.Builder requestBuilder = exchange.getRequest().mutate();
        ServiceInstance instance = this.choose(url, exchange, requestBuilder);
        if (instance == null) {
            throw new NotFoundException("Unable to find instance for " + url.getHost());
        }
        URI uri = exchange.getRequest().getURI();
        String string = overrideScheme = instance.isSecure() ? "https" : "http";
        if (schemePrefix != null) {
            overrideScheme = url.getScheme();
        }
        URI requestUrl = this.loadBalancer.reconstructURI((ServiceInstance)new DelegatingServiceInstance(instance, overrideScheme), uri);
        log.trace("LoadBalancerClientFilter url chosen: " + requestUrl);
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, requestUrl);
        ServerHttpRequest newRequest = requestBuilder.build();
        ServerWebExchange newExchange = exchange.mutate().request(newRequest).build();
        return chain.filter(newExchange);
    }

    protected ServiceInstance choose(URI url, ServerWebExchange exchange, ServerHttpRequest.Builder requestBuilder) {
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        GrayHttpRequest grayRequest = new GrayHttpRequest();
        grayRequest.setUri(serverHttpRequest.getURI());
        grayRequest.setServiceId(url.getHost().toLowerCase());
        grayRequest.addParameters((Map)serverHttpRequest.getQueryParams());
        if (this.grayRequestProperties.isLoadBody()) {
            grayRequest.setBody(((DataBuffer)serverHttpRequest.getBody().blockFirst()).asByteBuffer().array());
        }
        grayRequest.setMethod(serverHttpRequest.getMethodValue());
        HttpHeaders headers = new HttpHeaders();
        headers.addAll((MultiValueMap)serverHttpRequest.getHeaders());
        grayRequest.setHeaders((Map)headers);
        grayRequest.setAttribute(GRAY_REQUEST_ATTRIBUTE_GATEWAY_HTTPREQUEST_BUILDER, (Object)requestBuilder);
        GrayTrackInfo grayTrackInfo = (GrayTrackInfo)exchange.getAttributes().get("GrayWebTrack");
        if (grayTrackInfo != null) {
            this.requestLocalStorage.setGrayTrackInfo(grayTrackInfo);
        }
        RoutingConnectPointContext connectPointContext = RoutingConnectPointContext.builder().interceptroType("gateway").grayRequest((GrayRequest)grayRequest).build();
        return (ServiceInstance)this.routingConnectionPoint.execute(connectPointContext, () -> this.choose(exchange), grayCxt -> this.requestLocalStorage.removeGrayTrackInfo());
    }

    class DelegatingServiceInstance
    implements ServiceInstance {
        final ServiceInstance delegate;
        private String overrideScheme;

        DelegatingServiceInstance(ServiceInstance delegate, String overrideScheme) {
            this.delegate = delegate;
            this.overrideScheme = overrideScheme;
        }

        public String getServiceId() {
            return this.delegate.getServiceId();
        }

        public String getHost() {
            return this.delegate.getHost();
        }

        public int getPort() {
            return this.delegate.getPort();
        }

        public boolean isSecure() {
            return this.delegate.isSecure();
        }

        public URI getUri() {
            return this.delegate.getUri();
        }

        public Map<String, String> getMetadata() {
            return this.delegate.getMetadata();
        }

        public String getScheme() {
            String scheme = this.delegate.getScheme();
            if (scheme != null) {
                return scheme;
            }
            return this.overrideScheme;
        }
    }
}

