/*
 * Decompiled with CFR 0.152.
 */
package cn.springcloud.gray.web.filter;

import cn.springcloud.gray.GrayClientHolder;
import cn.springcloud.gray.mock.GrayReuqestMockInfo;
import cn.springcloud.gray.mock.MockManager;
import cn.springcloud.gray.model.HandleRuleType;
import cn.springcloud.gray.request.GrayHttpRequest;
import cn.springcloud.gray.request.GrayRequest;
import cn.springcloud.gray.request.GrayTrackInfo;
import cn.springcloud.gray.request.RequestLocalStorage;
import cn.springcloud.gray.response.http.HttpResponseMessage;
import cn.springcloud.gray.web.utils.WebFluxGrayHelper;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class GrayMockWebFilter
implements WebFilter {
    private static final Logger log = LoggerFactory.getLogger(GrayMockWebFilter.class);
    private RequestLocalStorage requestLocalStorage;
    private MockManager mockManager;

    public GrayMockWebFilter(RequestLocalStorage requestLocalStorage, MockManager mockManager) {
        this.requestLocalStorage = requestLocalStorage;
        this.mockManager = mockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (!this.mockManager.isEnableMock(HandleRuleType.MOCK_APPLICATION_RESPONSE.code())) {
            return chain.filter(exchange);
        }
        GrayClientHolder.getLocalStorageLifeCycle().initContext(GrayMockWebFilter.class.getName());
        try {
            GrayTrackInfoHolder grayTrackInfoHolder = this.getGrayTrackInfo(exchange);
            if (Objects.isNull(grayTrackInfoHolder)) {
                Mono mono = chain.filter(exchange);
                return mono;
            }
            GrayHttpRequest grayHttpRequest = this.createGrayHttpRequest(exchange.getRequest());
            grayHttpRequest.setGrayTrackInfo(grayTrackInfoHolder.getGrayTrackInfo());
            GrayReuqestMockInfo mockInfo = GrayReuqestMockInfo.builder().grayRequest((GrayRequest)grayHttpRequest).build();
            Object mockResult = this.mockManager.predicateAndExcuteMockHandle(HandleRuleType.MOCK_APPLICATION_RESPONSE.code(), mockInfo);
            if (Objects.isNull(mockResult)) {
                Mono mono = chain.filter(exchange);
                return mono;
            }
            HttpResponseMessage httpResponseMessage = HttpResponseMessage.toHttpResponseMessage((Object)mockResult);
            httpResponseMessage.getHeaders().toMap().forEach((n, v) -> exchange.getResponse().getHeaders().addAll(n, v));
            ServerHttpResponse response = exchange.getResponse();
            DataBuffer buffer = response.bufferFactory().wrap(httpResponseMessage.getBodyBytes());
            Mono mono = response.writeWith((Publisher)Mono.just((Object)buffer));
            return mono;
        }
        finally {
            GrayClientHolder.getLocalStorageLifeCycle().closeContext(GrayMockWebFilter.class.getName());
        }
    }

    private GrayTrackInfoHolder getGrayTrackInfo(ServerWebExchange exchange) {
        GrayTrackInfo trackInfo = this.requestLocalStorage.getGrayTrackInfo();
        if (Objects.nonNull(trackInfo)) {
            return new GrayTrackInfoHolder(trackInfo, false);
        }
        trackInfo = (GrayTrackInfo)WebFluxGrayHelper.getWebExchangAttribute(exchange, "GrayWebTrack");
        if (Objects.isNull(trackInfo)) {
            return null;
        }
        this.requestLocalStorage.setGrayTrackInfo(trackInfo);
        return new GrayTrackInfoHolder(trackInfo, true);
    }

    private GrayHttpRequest createGrayHttpRequest(ServerHttpRequest request) {
        GrayHttpRequest grayHttpRequest = new GrayHttpRequest();
        WebFluxGrayHelper.setHttpServerRequestInfoToGrayHttpRequest(request, grayHttpRequest);
        return grayHttpRequest;
    }

    private static class GrayTrackInfoHolder {
        private GrayTrackInfo grayTrackInfo;
        private boolean needRemoveLocalStorage;

        public GrayTrackInfo getGrayTrackInfo() {
            return this.grayTrackInfo;
        }

        public boolean isNeedRemoveLocalStorage() {
            return this.needRemoveLocalStorage;
        }

        public void setGrayTrackInfo(GrayTrackInfo grayTrackInfo) {
            this.grayTrackInfo = grayTrackInfo;
        }

        public void setNeedRemoveLocalStorage(boolean needRemoveLocalStorage) {
            this.needRemoveLocalStorage = needRemoveLocalStorage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GrayTrackInfoHolder)) {
                return false;
            }
            GrayTrackInfoHolder other = (GrayTrackInfoHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GrayTrackInfo this$grayTrackInfo = this.getGrayTrackInfo();
            GrayTrackInfo other$grayTrackInfo = other.getGrayTrackInfo();
            if (this$grayTrackInfo == null ? other$grayTrackInfo != null : !this$grayTrackInfo.equals(other$grayTrackInfo)) {
                return false;
            }
            return this.isNeedRemoveLocalStorage() == other.isNeedRemoveLocalStorage();
        }

        protected boolean canEqual(Object other) {
            return other instanceof GrayTrackInfoHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GrayTrackInfo $grayTrackInfo = this.getGrayTrackInfo();
            result = result * 59 + ($grayTrackInfo == null ? 43 : $grayTrackInfo.hashCode());
            result = result * 59 + (this.isNeedRemoveLocalStorage() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "GrayMockWebFilter.GrayTrackInfoHolder(grayTrackInfo=" + this.getGrayTrackInfo() + ", needRemoveLocalStorage=" + this.isNeedRemoveLocalStorage() + ")";
        }

        public GrayTrackInfoHolder(GrayTrackInfo grayTrackInfo, boolean needRemoveLocalStorage) {
            this.grayTrackInfo = grayTrackInfo;
            this.needRemoveLocalStorage = needRemoveLocalStorage;
        }
    }
}

