/*
 * Decompiled with CFR 0.152.
 */
package cn.springcloud.gray.web.filter;

import cn.springcloud.gray.request.GrayHttpTrackInfo;
import cn.springcloud.gray.request.GrayTrackInfo;
import cn.springcloud.gray.request.RequestLocalStorage;
import cn.springcloud.gray.request.track.GrayTrackHolder;
import cn.springcloud.gray.web.ServerHttpRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class GrayTrackWebFilter
implements WebFilter {
    private static final Logger log = LoggerFactory.getLogger(GrayTrackWebFilter.class);
    public static final String GRAY_WEB_TRACK_ATTR_NAME = "GrayWebTrack";
    private RequestLocalStorage requestLocalStorage;
    private GrayTrackHolder grayTrackHolder;

    public GrayTrackWebFilter(RequestLocalStorage requestLocalStorage, GrayTrackHolder grayTrackHolder) {
        this.requestLocalStorage = requestLocalStorage;
        this.grayTrackHolder = grayTrackHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        GrayHttpTrackInfo webTrack = new GrayHttpTrackInfo();
        this.requestLocalStorage.getLocalStorageLifeCycle().initContext();
        try {
            this.grayTrackHolder.recordGrayTrack((GrayTrackInfo)webTrack, (Object)new ServerHttpRequestWrapper(exchange.getRequest()));
            this.requestLocalStorage.setGrayTrackInfo((GrayTrackInfo)webTrack);
            this.recordGrayTrack(exchange, webTrack);
            Mono mono = chain.filter(exchange).doFinally(t -> this.requestLocalStorage.clearAll());
            return mono;
        }
        finally {
            this.requestLocalStorage.clearAll();
        }
    }

    private void recordGrayTrack(ServerWebExchange exchange, GrayHttpTrackInfo webTrack) {
        exchange.getAttributes().put(GRAY_WEB_TRACK_ATTR_NAME, webTrack);
    }
}

