/*
 * Decompiled with CFR 0.152.
 */
package cn.springcloud.gray.web.resources;

import cn.springcloud.gray.GrayManager;
import cn.springcloud.gray.api.ApiRes;
import cn.springcloud.gray.decision.PolicyDecisionManager;
import cn.springcloud.gray.decision.PolicyInfo;
import cn.springcloud.gray.model.GrayInstance;
import cn.springcloud.gray.model.GrayTrackDefinition;
import cn.springcloud.gray.request.track.GrayTrackHolder;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/gray/list"})
public class GrayListResource {
    @Autowired
    private GrayTrackHolder grayTrackHolder;
    @Autowired
    private PolicyDecisionManager policyDecisionManager;
    @Autowired
    private GrayManager grayManager;

    @GetMapping(value={"/service/allInfos"})
    public Mono<ApiRes<Map<String, Collection<GrayInstance>>>> getAllGrayServiceInfos() {
        return Mono.just((Object)ApiRes.builder().code("0").data((Object)this.grayManager.getMapByAllGrayServices()).build());
    }

    @GetMapping(value={"/policy/allInfos"})
    public Mono<ApiRes<Map<String, PolicyInfo>>> getAllPolicyInfos() {
        return Mono.just((Object)ApiRes.builder().code("0").data((Object)this.policyDecisionManager.getAllPolicyInfos()).build());
    }

    @GetMapping(value={"/track/allDefinitions"})
    public Mono<ApiRes<Collection<GrayTrackDefinition>>> getAllGrayTracks() {
        return Mono.just((Object)ApiRes.builder().code("0").data((Object)this.grayTrackHolder.getTrackDefinitions()).build());
    }
}

