/*
 * Decompiled with CFR 0.152.
 */
package cn.structure.starter.mybatis.configuration;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import cn.structure.starter.mybatis.configuration.EnableSplitDateSource;
import cn.structure.starter.mybatis.configuration.MybatisProperties;
import cn.structure.starter.mybatis.plugin.OverWritePluginParameter;
import com.github.pagehelper.PageInterceptor;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.ibatis.plugin.Interceptor;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ImportAutoConfiguration(value={MybatisProperties.class, EnableSplitDateSource.class})
public class AutoConfiguration {
    @Resource
    private MybatisProperties mybatisProperties;

    @Bean
    @ConditionalOnProperty(value={"structure.mybatis.plugin.over-write"}, havingValue="true")
    @ConditionalOnMissingBean(value={OverWritePluginParameter.class})
    public OverWritePluginParameter overWritePluginParameter() {
        return new OverWritePluginParameter();
    }

    @Bean
    @ConditionalOnMissingBean(value={Snowflake.class})
    public Snowflake snowflake() {
        Integer dataCenter = this.mybatisProperties.getDataCenter();
        Integer machine = this.mybatisProperties.getMachine();
        dataCenter = null == dataCenter ? 0 : dataCenter;
        machine = null == machine ? 0 : machine;
        return IdUtil.createSnowflake((long)machine.intValue(), (long)dataCenter.intValue());
    }

    @Bean
    @ConditionalOnMissingBean(value={Interceptor.class})
    public Interceptor getPageInterceptor() {
        PageInterceptor pageInterceptor = new PageInterceptor();
        Properties p = new Properties();
        p.setProperty("helperDialect", this.mybatisProperties.getPage().getHelperDialect());
        p.setProperty("params", this.mybatisProperties.getPage().getParams());
        p.setProperty("pageSizeZero", this.mybatisProperties.getPage().getPageSizeZero());
        p.setProperty("reasonable", this.mybatisProperties.getPage().getReasonable());
        p.setProperty("supportMethodsArguments", this.mybatisProperties.getPage().getSupportMethodsArguments());
        pageInterceptor.setProperties(p);
        return pageInterceptor;
    }
}

