/*
 * Decompiled with CFR 0.152.
 */
package cn.structure.starter.mybatis.plugin;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import cn.structure.starter.mybatis.annotation.CreateTime;
import cn.structure.starter.mybatis.annotation.UpdateTime;
import cn.structure.starter.mybatis.configuration.MybatisProperties;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Id;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="queryCursor", args={MappedStatement.class, Object.class, RowBounds.class})})
@Component
public class OverWritePluginParameter
implements Interceptor {
    @Autowired
    private Snowflake snowflake;
    @Autowired
    private MybatisProperties properties;

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
        SqlCommandType type = ms.getSqlCommandType();
        Object parameter = invocation.getArgs()[1];
        if (parameter != null) {
            if (parameter instanceof MapperMethod.ParamMap) {
                return invocation.proceed();
            }
            if (parameter instanceof Map) {
                Map param = (Map)parameter;
                if (null != param.get("collection")) {
                    List list = (List)param.get("collection");
                    for (int i = 0; i < list.size(); ++i) {
                        this.makeOverWrite(list.get(i), type);
                    }
                } else {
                    this.makeOverWrite(parameter, type);
                }
            } else {
                this.makeOverWrite(parameter, type);
            }
        }
        return invocation.proceed();
    }

    private void makeOverWrite(Object parameter, SqlCommandType type) throws IllegalAccessException, InstantiationException {
        Field[] declaredFields;
        for (Field field : declaredFields = parameter.getClass().getDeclaredFields()) {
            if (null != field.getAnnotation(Id.class) && SqlCommandType.INSERT.equals((Object)type)) {
                field.setAccessible(true);
                switch (this.properties.getGenerateIdType()) {
                    case UUID: {
                        field.set(parameter, IdUtil.simpleUUID());
                        break;
                    }
                    case SNOWFLAKE: {
                        if ("java.lang.Long".equals(field.getGenericType().getTypeName())) {
                            field.set(parameter, this.snowflake.nextId());
                            break;
                        }
                        field.set(parameter, String.valueOf(this.snowflake.nextId()));
                        break;
                    }
                }
            }
            if (null != field.getAnnotation(CreateTime.class) && SqlCommandType.INSERT.equals((Object)type)) {
                field.setAccessible(true);
                if (null == field.get(parameter)) {
                    field.set(parameter, field.getAnnotation(CreateTime.class).value().newInstance());
                }
            }
            if (null == field.getAnnotation(UpdateTime.class) || !SqlCommandType.INSERT.equals((Object)type) && !SqlCommandType.UPDATE.equals((Object)type)) continue;
            field.setAccessible(true);
            if (null != field.get(parameter)) continue;
            field.set(parameter, field.getAnnotation(UpdateTime.class).value().newInstance());
        }
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

