/*
 * Decompiled with CFR 0.152.
 */
package cn.structure.starter.mybatis.plugin;

import cn.structure.starter.mybatis.annotation.SplitTable;
import cn.structure.starter.mybatis.configuration.MybatisProperties;
import cn.structure.starter.mybatis.enums.SplitTableEnum;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class SplitDateSourcePlugin
implements Interceptor {
    @Resource
    private MybatisProperties mybatisProperties;
    private final Logger log = LoggerFactory.getLogger(SplitDateSourcePlugin.class);
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    private static final ReflectorFactory DEFAULT_REFLECTOR_FACTORY = new DefaultReflectorFactory();
    public static final String TABLE_NAME = "table_name";
    public static final String SPLIT_BY = "split_by";
    public static final String SPLIT_TYPE = "split_type";
    public static final String SPLIT_PARAM = "split_param";
    public static final String TIME_SPLIT_FORMAT = "time_split_format";
    public static final String EXECUTE_PARAM_DECLARE = "execute_param_declare";
    public static final String EXECUTE_PARAM_VALUES = "execute_param_values";
    public static final String ORIGINAL_SQL = "original_sql";
    public static final String SQL_COMMAND_TYPE = "sql_command_type";

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaStatementHandler = MetaObject.forObject((Object)statementHandler, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
        this.doSplitTable(metaStatementHandler);
        return invocation.proceed();
    }

    private void doSplitTable(MetaObject metaStatementHandler) throws Exception {
        String originalSql = (String)metaStatementHandler.getValue("delegate.boundSql.sql");
        if (originalSql != null && !originalSql.isEmpty()) {
            Object param = metaStatementHandler.getValue("delegate.boundSql.parameterObject");
            this.log.info("\u5206\u8868\u524d\u7684SQL\uff1a{}", (Object)originalSql);
            MappedStatement mappedStatement = (MappedStatement)metaStatementHandler.getValue("delegate.mappedStatement");
            String id = mappedStatement.getId();
            String className = id.substring(0, id.lastIndexOf("."));
            String methodName = id.substring(id.lastIndexOf(".") + 1);
            Class<?> clazz = Class.forName(className);
            ParameterMap paramMap = mappedStatement.getParameterMap();
            Method method = this.findMethod(clazz.getDeclaredMethods(), methodName);
            SplitTable splitTable = null;
            if (method != null) {
                splitTable = method.getAnnotation(SplitTable.class);
            }
            if (splitTable == null) {
                splitTable = clazz.getAnnotation(SplitTable.class);
            }
            String convertedSql = originalSql;
            if (splitTable != null) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(TABLE_NAME, splitTable.tableName());
                params.put(SPLIT_BY, splitTable.splitBy());
                params.put(SPLIT_TYPE, (Object)splitTable.splitType());
                params.put(SPLIT_PARAM, splitTable.keySplitParam());
                params.put(TIME_SPLIT_FORMAT, splitTable.timeSplitFormat());
                params.put(EXECUTE_PARAM_DECLARE, paramMap);
                params.put(EXECUTE_PARAM_VALUES, param);
                params.put(ORIGINAL_SQL, originalSql);
                params.put(SQL_COMMAND_TYPE, mappedStatement.getSqlCommandType());
                convertedSql = this.convert(params);
            }
            metaStatementHandler.setValue("delegate.boundSql.sql", (Object)convertedSql);
            this.log.info("\u5206\u8868\u540e\u7684SQL\uff1a{}", (Object)convertedSql);
        }
    }

    private String convert(Map<String, Object> params) throws Exception {
        Object objectParam = params.get(EXECUTE_PARAM_VALUES);
        HashMap<String, Object> splitParams = new HashMap<String, Object>();
        SplitTableEnum splitType = (SplitTableEnum)((Object)params.get(SPLIT_TYPE));
        if (null != objectParam) {
            String className = objectParam.getClass().getName();
            Class<?> clazz = Class.forName(className);
            if ("java.util.HashMap".equals(className)) {
                Object value;
                Map map = (Map)objectParam;
                if (splitType.equals((Object)SplitTableEnum.AREA_CODE)) {
                    value = map.get(params.get(SPLIT_BY));
                    splitParams.put(SPLIT_PARAM, value);
                }
                if (splitType.equals((Object)SplitTableEnum.TIME)) {
                    value = map.get(params.get(SPLIT_BY));
                    splitParams.put(SPLIT_BY, value);
                    Object value1 = map.get(params.get(SPLIT_PARAM));
                    splitParams.put(SPLIT_PARAM, value1);
                }
                if (splitType.equals((Object)SplitTableEnum.KEY)) {
                    Object value2 = map.get(params.get(SPLIT_BY));
                    splitParams.put(SPLIT_BY, value2);
                    splitParams.put(SPLIT_PARAM, params.get(SPLIT_PARAM));
                }
            } else {
                if (splitType.equals((Object)SplitTableEnum.TIME)) {
                    Method getTimeIntervalMethod;
                    Method getTimeMethod = this.findMethod(clazz.getDeclaredMethods(), "get" + this.captureName((String)params.get(SPLIT_BY)));
                    if (getTimeMethod != null) {
                        splitParams.put(SPLIT_BY, getTimeMethod.invoke(objectParam, new Object[0]));
                    }
                    if ((getTimeIntervalMethod = this.findMethod(clazz.getDeclaredMethods(), "get" + this.captureName((String)params.get(SPLIT_PARAM)))) != null) {
                        splitParams.put(SPLIT_PARAM, getTimeIntervalMethod.invoke(objectParam, new Object[0]));
                    }
                }
                if (splitType.equals((Object)SplitTableEnum.KEY)) {
                    Method getKeyMethod = this.findMethod(clazz.getDeclaredMethods(), "get" + this.captureName((String)params.get(SPLIT_BY)));
                    if (getKeyMethod != null) {
                        splitParams.put(SPLIT_BY, getKeyMethod.invoke(objectParam, new Object[0]));
                    }
                    splitParams.put(SPLIT_PARAM, params.get(SPLIT_PARAM));
                }
            }
        }
        String convertedSql = null;
        if (splitType.equals((Object)SplitTableEnum.TIME)) {
            convertedSql = this.areaSplit(params, splitParams);
        }
        if (splitType.equals((Object)SplitTableEnum.TIME)) {
            convertedSql = this.timeSplit(params, splitParams);
        }
        if (splitType.equals((Object)SplitTableEnum.KEY)) {
            convertedSql = this.keySplit(params, splitParams);
        }
        return convertedSql;
    }

    private String areaSplit(Map<String, Object> params, Map<String, Object> splitParams) {
        String originalSql = (String)params.get(ORIGINAL_SQL);
        StringBuilder newTableName = new StringBuilder((String)params.get(TABLE_NAME));
        String area = (String)splitParams.get(SPLIT_BY);
        newTableName.append("_").append(area);
        return this.replaceTableName(originalSql, (String)params.get(TABLE_NAME), newTableName.toString(), (SqlCommandType)params.get(SQL_COMMAND_TYPE), (ParameterMap)params.get(EXECUTE_PARAM_DECLARE));
    }

    private String timeSplit(Map<String, Object> params, Map<String, Object> splitParams) {
        String originalSql = (String)params.get(ORIGINAL_SQL);
        String timeSplitFormat = (String)params.get(TIME_SPLIT_FORMAT);
        SimpleDateFormat sdf = new SimpleDateFormat(timeSplitFormat);
        Date date = splitParams.get(SPLIT_BY) != null ? (Date)splitParams.get(SPLIT_BY) : new Date();
        int size = splitParams.get(SPLIT_PARAM) != null ? ((Integer)splitParams.get(SPLIT_PARAM)).intValue() : this.mybatisProperties.getSplitLength().intValue();
        if (params.get(SQL_COMMAND_TYPE).equals(SqlCommandType.SELECT)) {
            StringBuilder unionTable = new StringBuilder("(");
            String unionSelect = "( SELECT * FROM " + params.get(TABLE_NAME).toString() + ")";
            for (int i = 0; i < size; ++i) {
                StringBuilder tableName = new StringBuilder(params.get(TABLE_NAME).toString());
                Calendar c = Calendar.getInstance();
                c.setTime(date);
                c.add(2, i * -1);
                Date m = c.getTime();
                String mon = sdf.format(m);
                tableName.append("_");
                tableName.append(mon);
                unionTable.append(unionSelect.replaceAll(params.get(TABLE_NAME).toString(), tableName.toString()));
                if (i != size - 1) {
                    unionTable.append(" UNION ");
                    continue;
                }
                unionTable.append(") ac");
            }
            return this.replaceTableName(originalSql, params.get(TABLE_NAME).toString(), unionTable.toString(), (SqlCommandType)params.get(SQL_COMMAND_TYPE), (ParameterMap)params.get(EXECUTE_PARAM_DECLARE));
        }
        StringBuilder tableName = new StringBuilder(params.get(TABLE_NAME).toString());
        String mon = sdf.format(date);
        tableName.append("_");
        tableName.append(mon);
        return this.replaceTableName(originalSql, params.get(TABLE_NAME).toString(), tableName.toString(), (SqlCommandType)params.get(SQL_COMMAND_TYPE), (ParameterMap)params.get(EXECUTE_PARAM_DECLARE));
    }

    private String keySplit(Map<String, Object> params, Map<String, Object> splitParams) {
        String originalSql = (String)params.get(ORIGINAL_SQL);
        StringBuilder newTableName = new StringBuilder((String)params.get(TABLE_NAME));
        Long id = (Long)splitParams.get(SPLIT_BY);
        Integer splitParam = (Integer)splitParams.get(SPLIT_PARAM);
        Long tableNameAfter = id % (long)splitParam.intValue();
        newTableName.append("_").append(tableNameAfter);
        return this.replaceTableName(originalSql, (String)params.get(TABLE_NAME), newTableName.toString(), (SqlCommandType)params.get(SQL_COMMAND_TYPE), (ParameterMap)params.get(EXECUTE_PARAM_DECLARE));
    }

    private String replaceTableName(String originalSql, String tableName, String newTableName, SqlCommandType sqlType, ParameterMap parameterMap) {
        this.log.info(parameterMap.toString());
        StringBuilder newSql = new StringBuilder();
        String sqlTypeStr = null;
        if (sqlType.equals((Object)SqlCommandType.INSERT)) {
            sqlTypeStr = "INSERT INTO ";
        }
        if (sqlType.equals((Object)SqlCommandType.UPDATE)) {
            sqlTypeStr = "UPDATE ";
        }
        if (sqlType.equals((Object)SqlCommandType.SELECT) || sqlType.equals((Object)SqlCommandType.DELETE)) {
            sqlTypeStr = "FROM ";
        }
        assert (sqlTypeStr != null);
        int sqlTypeStrIndex = originalSql.indexOf(sqlTypeStr);
        if (sqlTypeStrIndex == -1) {
            return originalSql;
        }
        int tableNameIndex = originalSql.indexOf(tableName, sqlTypeStrIndex);
        String sqlBefore = originalSql.substring(0, sqlTypeStrIndex + sqlTypeStr.length());
        String sqlAfter = originalSql.substring(tableNameIndex + tableName.length());
        newSql.append(sqlBefore).append(newTableName).append(sqlAfter);
        return newSql.toString();
    }

    private Method findMethod(Method[] methods, String methodName) {
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    private String captureName(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

