/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.web;

import cn.t.util.common.ArrayUtil;
import cn.t.util.common.RegexUtil;
import cn.t.util.common.StringUtil;
import cn.t.util.common.SystemUtil;
import cn.t.util.web.CookieOption;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestUtil {
    private static final Pattern PATTERN = Pattern.compile("https?://(.*?)/");

    public static String getCookie(HttpServletRequest request, String cookieName) {
        Object[] cookies = request.getCookies();
        if (!ArrayUtil.isEmpty((Object[])cookies)) {
            for (Object cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static void deleteCookie(HttpServletResponse response, String cookieName) throws UnsupportedEncodingException {
        RequestUtil.deleteCookie(response, null, cookieName);
    }

    public static void deleteCookie(HttpServletResponse response, String path, String cookieName) throws UnsupportedEncodingException {
        RequestUtil.setCookie(response, null, path, cookieName, null, (Integer)0, new CookieOption[0]);
    }

    public static void setCookie(HttpServletResponse response, String domain, String cookieName, String cookieValue, Integer maxAge) throws UnsupportedEncodingException {
        RequestUtil.setCookie(response, domain, null, cookieName, cookieValue, maxAge, new CookieOption[0]);
    }

    public static void setCookie(HttpServletResponse response, String domain, String cookieName, String cookieValue, Integer maxAge, CookieOption ... options) throws UnsupportedEncodingException {
        RequestUtil.setCookie(response, domain, null, cookieName, cookieValue, maxAge, options);
    }

    public static void setCookie(HttpServletResponse response, String domain, String path, String cookieName, String cookieValue, Integer maxAge, CookieOption ... options) throws UnsupportedEncodingException {
        RequestUtil.setCookie(response, domain, path, cookieName, cookieValue, maxAge, false, options);
    }

    public static void setCookie(HttpServletResponse response, String domain, String path, String cookieName, String cookieValue, Integer maxAge, boolean isEncode, CookieOption ... options) throws UnsupportedEncodingException {
        if (cookieValue == null) {
            cookieValue = "";
        } else if (isEncode) {
            cookieValue = URLEncoder.encode(cookieValue, "UTF-8");
        }
        Cookie cookie = new Cookie(cookieName, cookieValue);
        if (maxAge != null) {
            cookie.setMaxAge(maxAge.intValue());
        }
        if (!StringUtil.isEmpty((String)domain)) {
            cookie.setDomain(domain);
        }
        if (StringUtil.isEmpty((String)path)) {
            cookie.setPath("/");
        } else {
            cookie.setPath(path);
        }
        if (options != null && options.length > 0) {
            for (CookieOption cookieOption : options) {
                cookieOption.configCookie(cookie);
            }
        }
        response.addCookie(cookie);
    }

    public static String getTopDomain(HttpServletRequest request) {
        return RequestUtil.getTopDomain(request.getRequestURL().toString().toLowerCase());
    }

    public static String getTopDomain(String url) {
        Matcher matcher = PATTERN.matcher(url);
        boolean success = matcher.find();
        if (!success) {
            throw new RuntimeException("could not find domain for: " + url);
        }
        String domain = matcher.group(1);
        if (RegexUtil.isIp((String)(domain = domain.split(":")[0]))) {
            return domain;
        }
        StringBuilder builder = new StringBuilder(domain);
        int count = 0;
        for (int i = builder.length() - 1; i >= 0; --i) {
            if (count > 1) {
                builder.deleteCharAt(i);
                continue;
            }
            if (builder.charAt(i) != '.') continue;
            ++count;
        }
        while (builder.charAt(0) == '.') {
            builder.deleteCharAt(0);
        }
        return builder.toString();
    }

    public String getRemoteAddress(HttpServletRequest request) {
        String ipAddress = request.getHeader("X-FORWARDED-FOR");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("X-Real-IP");
        }
        if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && ((ipAddress = request.getRemoteAddr()).equals("127.0.0.1") || ipAddress.equals("0:0:0:0:0:0:0:1"))) {
            ipAddress = SystemUtil.getCashedLocalPrivateIpV4();
        }
        if (ipAddress != null && ipAddress.contains(",") && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }
}

