/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop;

import cn.taketoday.aop.EnableAspectAutoProxy;
import cn.taketoday.aop.proxy.ProxyConfig;
import cn.taketoday.aop.proxy.ProxyCreator;
import cn.taketoday.aop.support.annotation.AspectAutoProxyCreator;
import cn.taketoday.aop.target.TargetSourceCreator;
import cn.taketoday.context.AnnotationAttributes;
import cn.taketoday.context.annotation.MissingBean;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanDefinitionRegistry;
import cn.taketoday.context.loader.BeanDefinitionImporter;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ObjectUtils;

class AutoProxyConfiguration
implements BeanDefinitionImporter {
    AutoProxyConfiguration() {
    }

    @MissingBean(type=ProxyCreator.class)
    static AspectAutoProxyCreator aspectAutoProxyCreator(TargetSourceCreator[] sourceCreators) {
        AspectAutoProxyCreator proxyCreator = new AspectAutoProxyCreator();
        if (ObjectUtils.isNotEmpty(sourceCreators)) {
            proxyCreator.setTargetSourceCreators(sourceCreators);
        }
        return proxyCreator;
    }

    @Override
    public void registerBeanDefinitions(BeanDefinition annotatedMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes aspectAutoProxy;
        BeanDefinition proxyCreatorDef = registry.getBeanDefinition(ProxyCreator.class);
        Assert.state(proxyCreatorDef != null, "No ProxyCreator bean definition.");
        if (ProxyConfig.class.isAssignableFrom(proxyCreatorDef.getBeanClass()) && (aspectAutoProxy = ClassUtils.getAnnotationAttributes(EnableAspectAutoProxy.class, annotatedMetadata)) != null) {
            proxyCreatorDef.addPropertyValue("exposeProxy", aspectAutoProxy.getBoolean("exposeProxy"));
            proxyCreatorDef.addPropertyValue("proxyTargetClass", aspectAutoProxy.getBoolean("proxyTargetClass"));
        }
    }
}

