/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.proxy;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.AopInvocationException;
import cn.taketoday.aop.PointcutAdvisor;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.proxy.AbstractSubclassesAopProxy;
import cn.taketoday.aop.proxy.Advised;
import cn.taketoday.aop.proxy.AdvisedSupport;
import cn.taketoday.aop.proxy.AopContext;
import cn.taketoday.aop.proxy.AopProxy;
import cn.taketoday.aop.proxy.AopProxyUtils;
import cn.taketoday.aop.proxy.DefaultMethodInvocation;
import cn.taketoday.context.cglib.proxy.Callback;
import cn.taketoday.context.cglib.proxy.CallbackFilter;
import cn.taketoday.context.cglib.proxy.Dispatcher;
import cn.taketoday.context.cglib.proxy.Enhancer;
import cn.taketoday.context.cglib.proxy.Factory;
import cn.taketoday.context.cglib.proxy.MethodProxy;
import cn.taketoday.context.cglib.proxy.NoOp;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.context.utils.ReflectionUtils;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;

public class CglibAopProxy
extends AbstractSubclassesAopProxy
implements AopProxy,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(CglibAopProxy.class);
    private static final int AOP_PROXY = 0;
    private static final int INVOKE_TARGET = 1;
    private static final int NO_OVERRIDE = 2;
    private static final int DISPATCH_TARGET = 3;
    private static final int DISPATCH_ADVISED = 4;
    private static final int INVOKE_EQUALS = 5;
    private static final int INVOKE_HASHCODE = 6;
    private transient Map<Method, Integer> fixedInterceptorMap = Collections.emptyMap();
    private transient int fixedInterceptorOffset;

    public CglibAopProxy(AdvisedSupport config) {
        super(config);
    }

    @Override
    public Object getProxy(ClassLoader classLoader, Function<Constructor<?>, Object[]> argsFunction) {
        if (log.isTraceEnabled()) {
            log.trace("Creating CGLIB proxy: {}", (Object)this.config.getTargetSource());
        }
        return super.getProxy(classLoader, argsFunction);
    }

    @Override
    protected Object getProxyInternal(Class<?> proxySuperClass, ClassLoader classLoader, Function<Constructor<?>, Object[]> argsFunction) throws Exception {
        Class<?> rootClass = this.config.getTargetClass();
        Enhancer enhancer = this.createEnhancer();
        if (classLoader != null) {
            enhancer.setClassLoader(classLoader);
        }
        enhancer.setSuperclass(proxySuperClass);
        enhancer.setInterfaces(AopProxyUtils.completeProxiedInterfaces(this.config));
        Callback[] callbacks = this.getCallbacks(rootClass);
        Class[] types = new Class[callbacks.length];
        for (int x = 0; x < types.length; ++x) {
            types[x] = callbacks[x].getClass();
        }
        enhancer.setCallbackFilter(new ProxyCallbackFilter(this.config.getConfigurationOnlyCopy(), this.fixedInterceptorMap, this.fixedInterceptorOffset));
        enhancer.setCallbackTypes(types);
        this.computeConstructorArguments(argsFunction, proxySuperClass);
        return this.createProxyClassAndInstance(enhancer, callbacks);
    }

    protected Object createProxyClassAndInstance(Enhancer enhancer, Callback[] callbacks) {
        enhancer.setInterceptDuringConstruction(false);
        enhancer.setCallbacks(callbacks);
        return this.constructorArgs != null && this.constructorArgTypes != null ? enhancer.create(this.constructorArgTypes, this.constructorArgs) : enhancer.create();
    }

    protected Enhancer createEnhancer() {
        return new Enhancer();
    }

    Callback[] getCallbacks(Class<?> rootClass) throws Exception {
        Callback[] mainCallbacks;
        AdvisedSupport config = this.config;
        boolean exposeProxy = config.isExposeProxy();
        boolean isFrozen = config.isFrozen();
        boolean isStatic = config.getTargetSource().isStatic();
        DynamicAdvisedInterceptor aopInterceptor = new DynamicAdvisedInterceptor(config);
        cn.taketoday.context.cglib.proxy.MethodInterceptor targetInterceptor = exposeProxy ? (isStatic ? new StaticUnadvisedExposedInterceptor(config.getTargetSource().getTarget()) : new DynamicUnadvisedExposedInterceptor(config.getTargetSource())) : (isStatic ? new StaticUnadvisedInterceptor(config.getTargetSource().getTarget()) : new DynamicUnadvisedInterceptor(config.getTargetSource()));
        Callback targetDispatcher = isStatic ? new StaticDispatcher(config.getTargetSource().getTarget()) : new SerializableNoOp();
        Callback[] callbacks = mainCallbacks = new Callback[]{aopInterceptor, targetInterceptor, new SerializableNoOp(), targetDispatcher, new AdvisedDispatcher(config), new EqualsInterceptor(config), new HashCodeInterceptor(config)};
        if (isStatic && isFrozen) {
            Method[] methods = rootClass.getMethods();
            Callback[] fixedCallbacks = new Callback[methods.length];
            this.fixedInterceptorMap = new HashMap<Method, Integer>(methods.length);
            for (int x = 0; x < methods.length; ++x) {
                Method method = methods[x];
                MethodInterceptor[] chain = config.getInterceptors(method, rootClass);
                fixedCallbacks[x] = new FixedChainStaticTargetInterceptor(chain, config);
                this.fixedInterceptorMap.put(method, x);
            }
            callbacks = new Callback[mainCallbacks.length + fixedCallbacks.length];
            System.arraycopy(mainCallbacks, 0, callbacks, 0, mainCallbacks.length);
            System.arraycopy(fixedCallbacks, 0, callbacks, mainCallbacks.length, fixedCallbacks.length);
            this.fixedInterceptorOffset = mainCallbacks.length;
        }
        return callbacks;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CglibAopProxy && AopProxyUtils.equalsInProxy(this.config, ((CglibAopProxy)other).config);
    }

    public int hashCode() {
        return CglibAopProxy.class.hashCode() * 13 + this.config.getTargetSource().hashCode();
    }

    private static Object processReturnValue(Object proxy, Object target, Method method, Object retVal) {
        Class<?> returnType;
        if (retVal != null && retVal == target) {
            retVal = proxy;
        }
        if (retVal == null && (returnType = method.getReturnType()) != Void.TYPE && returnType.isPrimitive()) {
            throw new AopInvocationException("Null return value from advice does not match primitive return type for: " + method);
        }
        return retVal;
    }

    static class ProxyCallbackFilter
    implements CallbackFilter {
        final AdvisedSupport advised;
        final int fixedInterceptorOffset;
        final Map<Method, Integer> fixedInterceptorMap;

        public ProxyCallbackFilter(AdvisedSupport advised, Map<Method, Integer> fixedInterceptorMap, int fixedInterceptorOffset) {
            this.advised = advised;
            this.fixedInterceptorMap = fixedInterceptorMap;
            this.fixedInterceptorOffset = fixedInterceptorOffset;
        }

        @Override
        public int accept(Method method) {
            if (ReflectionUtils.isFinalizeMethod(method)) {
                log.trace("Found finalize() method - using NO_OVERRIDE");
                return 2;
            }
            AdvisedSupport advised = this.advised;
            if (!advised.isOpaque() && method.getDeclaringClass().isInterface() && method.getDeclaringClass().isAssignableFrom(Advised.class)) {
                if (log.isTraceEnabled()) {
                    log.trace("Method is declared on Advised interface: {}", (Object)method);
                }
                return 4;
            }
            if (ReflectionUtils.isEqualsMethod(method)) {
                if (log.isTraceEnabled()) {
                    log.trace("Found 'equals' method: {}", (Object)method);
                }
                return 5;
            }
            if (ReflectionUtils.isHashCodeMethod(method)) {
                if (log.isTraceEnabled()) {
                    log.trace("Found 'hashCode' method: {}", (Object)method);
                }
                return 6;
            }
            Class<?> targetClass = advised.getTargetClass();
            Object[] chain = advised.getInterceptors(method, targetClass);
            boolean haveAdvice = ObjectUtils.isNotEmpty(chain);
            boolean exposeProxy = advised.isExposeProxy();
            boolean isStatic = advised.getTargetSource().isStatic();
            boolean isFrozen = advised.isFrozen();
            if (haveAdvice || !isFrozen) {
                if (exposeProxy) {
                    if (log.isTraceEnabled()) {
                        log.trace("Must expose proxy on advised method: {}", (Object)method);
                    }
                    return 0;
                }
                if (isStatic && isFrozen && this.fixedInterceptorMap.containsKey(method)) {
                    if (log.isTraceEnabled()) {
                        log.trace("Method has advice and optimizations are enabled: {}", (Object)method);
                    }
                    int index = this.fixedInterceptorMap.get(method);
                    return index + this.fixedInterceptorOffset;
                }
                if (log.isTraceEnabled()) {
                    log.trace("Unable to apply any optimizations to advised method: {}", (Object)method);
                }
                return 0;
            }
            if (exposeProxy || !isStatic) {
                return 1;
            }
            Class<?> returnType = method.getReturnType();
            if (targetClass != null && returnType.isAssignableFrom(targetClass)) {
                if (log.isTraceEnabled()) {
                    log.trace("Method return type is assignable from target type and may therefore return 'this' - using INVOKE_TARGET: {}", (Object)method);
                }
                return 1;
            }
            if (log.isTraceEnabled()) {
                log.trace("Method return type ensures 'this' cannot be returned - using DISPATCH_TARGET: {}", (Object)method);
            }
            return 3;
        }

        @Override
        public boolean equals(Object other) {
            Advisor[] thatAdvisors;
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProxyCallbackFilter)) {
                return false;
            }
            AdvisedSupport advised = this.advised;
            ProxyCallbackFilter otherCallbackFilter = (ProxyCallbackFilter)other;
            AdvisedSupport otherAdvised = otherCallbackFilter.advised;
            if (advised.isFrozen() != otherAdvised.isFrozen()) {
                return false;
            }
            if (advised.isExposeProxy() != otherAdvised.isExposeProxy()) {
                return false;
            }
            if (advised.getTargetSource().isStatic() != otherAdvised.getTargetSource().isStatic()) {
                return false;
            }
            if (!AopProxyUtils.equalsProxiedInterfaces(advised, otherAdvised)) {
                return false;
            }
            Advisor[] thisAdvisors = advised.getAdvisors();
            if (thisAdvisors.length != (thatAdvisors = otherAdvised.getAdvisors()).length) {
                return false;
            }
            for (int i = 0; i < thisAdvisors.length; ++i) {
                Advisor thisAdvisor = thisAdvisors[i];
                Advisor thatAdvisor = thatAdvisors[i];
                if (!ProxyCallbackFilter.equalsAdviceClasses(thisAdvisor, thatAdvisor)) {
                    return false;
                }
                if (ProxyCallbackFilter.equalsPointcuts(thisAdvisor, thatAdvisor)) continue;
                return false;
            }
            return true;
        }

        static boolean equalsAdviceClasses(Advisor a, Advisor b) {
            return a.getAdvice().getClass() == b.getAdvice().getClass();
        }

        static boolean equalsPointcuts(Advisor a, Advisor b) {
            return !(a instanceof PointcutAdvisor) || b instanceof PointcutAdvisor && Objects.equals(((PointcutAdvisor)a).getPointcut(), ((PointcutAdvisor)b).getPointcut());
        }

        public int hashCode() {
            Advisor[] advisors;
            int hashCode = 0;
            AdvisedSupport advised = this.advised;
            for (Advisor advisor : advisors = advised.getAdvisors()) {
                Advice advice = advisor.getAdvice();
                hashCode = 13 * hashCode + advice.getClass().hashCode();
            }
            hashCode = 13 * hashCode + (advised.isFrozen() ? 1 : 0);
            hashCode = 13 * hashCode + (advised.isExposeProxy() ? 1 : 0);
            hashCode = 13 * hashCode + (advised.isOptimize() ? 1 : 0);
            hashCode = 13 * hashCode + (advised.isOpaque() ? 1 : 0);
            return hashCode;
        }
    }

    static class CglibMethodInvocation
    extends DefaultMethodInvocation {
        final MethodProxy proxy;

        public CglibMethodInvocation(Object target, Method method, Class<?> targetClass, MethodProxy proxy, Object[] arguments, MethodInterceptor[] advices) {
            super(target, method, targetClass, arguments, advices);
            this.proxy = proxy;
        }

        @Override
        protected Object invokeJoinPoint() throws Throwable {
            return this.proxy.invoke(this.target, this.args);
        }

        @Override
        public Object proceed() throws Throwable {
            try {
                return super.proceed();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (ReflectionUtils.declaresException(this.getMethod(), ex.getClass())) {
                    throw ex;
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
    }

    static class DynamicAdvisedInterceptor
    implements cn.taketoday.context.cglib.proxy.MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = 1L;
        final AdvisedSupport advised;

        public DynamicAdvisedInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            boolean restore = false;
            Object target = null;
            AdvisedSupport advised = this.advised;
            TargetSource targetSource = advised.getTargetSource();
            try {
                Object retVal;
                Class<?> targetClass;
                Object[] chain;
                if (advised.isExposeProxy()) {
                    oldProxy = AopContext.setCurrentProxy(proxy);
                    restore = true;
                }
                if (ObjectUtils.isEmpty(chain = advised.getInterceptors(method, targetClass = (target = targetSource.getTarget()) != null ? target.getClass() : null)) && Modifier.isPublic(method.getModifiers())) {
                    Object[] argsToUse = ClassUtils.adaptArgumentsIfNecessary(method, args);
                    retVal = methodProxy.invoke(target, argsToUse);
                } else {
                    retVal = new CglibMethodInvocation(target, method, targetClass, methodProxy, args, (MethodInterceptor[])chain).proceed();
                }
                Object object = CglibAopProxy.processReturnValue(proxy, target, method, retVal);
                return object;
            }
            finally {
                if (target != null && !targetSource.isStatic()) {
                    targetSource.releaseTarget(target);
                }
                if (restore) {
                    AopContext.setCurrentProxy(oldProxy);
                }
            }
        }

        public boolean equals(Object other) {
            return this == other || other instanceof DynamicAdvisedInterceptor && this.advised.equals(((DynamicAdvisedInterceptor)other).advised);
        }

        public int hashCode() {
            return this.advised.hashCode();
        }
    }

    static class FixedChainStaticTargetInterceptor
    implements cn.taketoday.context.cglib.proxy.MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = 1L;
        final Object target;
        final Class<?> targetClass;
        final MethodInterceptor[] adviceChain;

        public FixedChainStaticTargetInterceptor(MethodInterceptor[] adviceChain, AdvisedSupport config) throws Exception {
            this.adviceChain = adviceChain;
            this.targetClass = config.getTargetClass();
            this.target = config.getTargetSource().getTarget();
        }

        @Override
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            return new CglibMethodInvocation(this.target, method, this.targetClass, methodProxy, args, this.adviceChain).proceed();
        }
    }

    static class HashCodeInterceptor
    implements cn.taketoday.context.cglib.proxy.MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = 1L;
        final AdvisedSupport advised;

        public HashCodeInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        @Override
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) {
            return CglibAopProxy.class.hashCode() * 13 + this.advised.getTargetSource().hashCode();
        }
    }

    static class EqualsInterceptor
    implements cn.taketoday.context.cglib.proxy.MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = 1L;
        final AdvisedSupport advised;

        public EqualsInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        @Override
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) {
            Object other = args[0];
            if (proxy == other) {
                return true;
            }
            if (other instanceof Factory) {
                Callback callback = ((Factory)other).getCallback(5);
                if (!(callback instanceof EqualsInterceptor)) {
                    return false;
                }
                AdvisedSupport otherAdvised = ((EqualsInterceptor)callback).advised;
                return AopProxyUtils.equalsInProxy(this.advised, otherAdvised);
            }
            return false;
        }
    }

    static class AdvisedDispatcher
    implements Dispatcher,
    Serializable {
        private static final long serialVersionUID = 1L;
        final AdvisedSupport advised;

        public AdvisedDispatcher(AdvisedSupport advised) {
            this.advised = advised;
        }

        @Override
        public Object loadObject() {
            return this.advised;
        }
    }

    static class StaticDispatcher
    implements Dispatcher,
    Serializable {
        private static final long serialVersionUID = 1L;
        final Object target;

        public StaticDispatcher(Object target) {
            this.target = target;
        }

        @Override
        public Object loadObject() {
            return this.target;
        }
    }

    static class DynamicUnadvisedExposedInterceptor
    implements cn.taketoday.context.cglib.proxy.MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = 1L;
        final TargetSource targetSource;

        public DynamicUnadvisedExposedInterceptor(TargetSource targetSource) {
            this.targetSource = targetSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            Object target = this.targetSource.getTarget();
            try {
                oldProxy = AopContext.setCurrentProxy(proxy);
                Object object = methodProxy.invoke(target, args);
                return object;
            }
            finally {
                AopContext.setCurrentProxy(oldProxy);
                if (target != null) {
                    this.targetSource.releaseTarget(target);
                }
            }
        }
    }

    static class DynamicUnadvisedInterceptor
    implements cn.taketoday.context.cglib.proxy.MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = 1L;
        final TargetSource targetSource;

        public DynamicUnadvisedInterceptor(TargetSource targetSource) {
            this.targetSource = targetSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object target = this.targetSource.getTarget();
            try {
                Object object = methodProxy.invoke(target, args);
                return object;
            }
            finally {
                if (target != null) {
                    this.targetSource.releaseTarget(target);
                }
            }
        }
    }

    static class StaticUnadvisedExposedInterceptor
    implements cn.taketoday.context.cglib.proxy.MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = 1L;
        final Object target;

        public StaticUnadvisedExposedInterceptor(Object target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            try {
                oldProxy = AopContext.setCurrentProxy(proxy);
                Object object = methodProxy.invoke(this.target, args);
                return object;
            }
            finally {
                AopContext.setCurrentProxy(oldProxy);
            }
        }
    }

    static class StaticUnadvisedInterceptor
    implements cn.taketoday.context.cglib.proxy.MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = 1L;
        final Object target;

        public StaticUnadvisedInterceptor(Object target) {
            this.target = target;
        }

        @Override
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            return methodProxy.invoke(this.target, args);
        }
    }

    public static class SerializableNoOp
    implements NoOp,
    Serializable {
        private static final long serialVersionUID = 1L;
    }
}

