/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.proxy;

import cn.taketoday.aop.proxy.AbstractMethodInvocation;
import cn.taketoday.aop.support.AopUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class DefaultMethodInvocation
extends AbstractMethodInvocation
implements MethodInvocation {
    protected Object[] args;
    protected final Object target;
    protected final Method method;
    protected final Class<?> targetClass;
    protected final MethodInterceptor[] advices;
    private int currentAdviceIndex = 0;
    private final int adviceLength;

    public DefaultMethodInvocation(Method method, Class<?> targetClass, Object[] arguments) {
        this(null, method, targetClass, arguments, null);
    }

    public DefaultMethodInvocation(Object target, Method method, Class<?> targetClass, Object[] arguments, MethodInterceptor[] advices) {
        this.target = target;
        this.method = method;
        this.targetClass = targetClass;
        this.args = arguments;
        this.advices = advices;
        this.adviceLength = advices != null ? advices.length : 0;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object[] getArguments() {
        return this.args;
    }

    @Override
    protected void setArguments(Object[] arguments) {
        this.args = arguments;
    }

    @Override
    protected Object invokeJoinPoint() throws Throwable {
        return AopUtils.invokeJoinpointUsingReflection(this.target, this.method, this.args);
    }

    @Override
    protected boolean hasInterceptor() {
        return this.currentAdviceIndex < this.adviceLength;
    }

    @Override
    protected Object executeInterceptor() throws Throwable {
        return this.advices[this.currentAdviceIndex++].invoke(this);
    }

    @Override
    public Object getThis() {
        return this.target;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public AccessibleObject getStaticPart() {
        return this.method;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultMethodInvocation)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultMethodInvocation that = (DefaultMethodInvocation)o;
        return this.currentAdviceIndex == that.currentAdviceIndex && this.adviceLength == that.adviceLength && Arrays.equals(this.args, that.args) && Objects.equals(this.target, that.target) && Objects.equals(this.method, that.method) && Arrays.equals(this.advices, that.advices);
    }

    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.target, this.method);
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + Arrays.hashCode(this.advices);
        return result;
    }

    public String toString() {
        return "{\n\t\"target\":\"" + this.target + "\",\n\t\"method\":\"" + this.method + "\",\n\t\"arguments\":\"" + Arrays.toString(this.args) + "\",\n\t\"advices\":\"" + Arrays.toString(this.advices) + "\",\n\t\"currentAdviceIndex\":\"" + this.currentAdviceIndex + "\"\n}";
    }
}

