/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.proxy;

import cn.taketoday.aop.AopInvocationException;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.proxy.Advised;
import cn.taketoday.aop.proxy.AdvisedSupport;
import cn.taketoday.aop.proxy.AopConfigException;
import cn.taketoday.aop.proxy.AopContext;
import cn.taketoday.aop.proxy.AopProxy;
import cn.taketoday.aop.proxy.AopProxyUtils;
import cn.taketoday.aop.proxy.DefaultMethodInvocation;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.context.DecoratingProxy;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.context.utils.ReflectionUtils;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Function;
import org.aopalliance.intercept.MethodInterceptor;

public class JdkDynamicAopProxy
implements AopProxy,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JdkDynamicAopProxy.class);
    private final AdvisedSupport advised;
    private boolean equalsDefined;
    private boolean hashCodeDefined;
    private final Class<?>[] proxiedInterfaces;

    public JdkDynamicAopProxy(AdvisedSupport config) {
        Assert.notNull((Object)config, "AdvisedSupport must not be null");
        if (config.getAdvisors().length == 0 && config.getTargetSource() == AdvisedSupport.EMPTY_TARGET_SOURCE) {
            throw new AopConfigException("No advisors and no TargetSource specified");
        }
        this.advised = config;
        this.proxiedInterfaces = AopProxyUtils.completeProxiedInterfaces(config, true);
        this.findDefinedEqualsAndHashCodeMethods(this.proxiedInterfaces);
    }

    @Override
    public Object getProxy() {
        return this.getProxy(ClassUtils.getClassLoader());
    }

    @Override
    public Object getProxy(ClassLoader classLoader, Function<Constructor<?>, Object[]> argsFunction) {
        if (logger.isTraceEnabled()) {
            logger.trace("Creating JDK dynamic proxy: {}", (Object)this.advised.getTargetSource());
        }
        return Proxy.newProxyInstance(classLoader, this.proxiedInterfaces, (InvocationHandler)this);
    }

    void findDefinedEqualsAndHashCodeMethods(Class<?>[] proxiedInterfaces) {
        for (Class<?> proxiedInterface : proxiedInterfaces) {
            Method[] methods;
            for (Method method : methods = proxiedInterface.getDeclaredMethods()) {
                if (ReflectionUtils.isEqualsMethod(method)) {
                    this.equalsDefined = true;
                }
                if (ReflectionUtils.isHashCodeMethod(method)) {
                    this.hashCodeDefined = true;
                }
                if (!this.equalsDefined || !this.hashCodeDefined) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        boolean setProxyContext;
        Object oldProxy;
        block24: {
            Object retVal;
            Class<?> targetClass;
            Object[] chain;
            Object target;
            TargetSource targetSource;
            AdvisedSupport advised;
            block22: {
                Object object2;
                block23: {
                    block20: {
                        Class<?> clazz;
                        block21: {
                            block18: {
                                Integer n;
                                block19: {
                                    block16: {
                                        Boolean bl;
                                        block17: {
                                            oldProxy = null;
                                            setProxyContext = false;
                                            advised = this.advised;
                                            targetSource = advised.getTargetSource();
                                            target = null;
                                            try {
                                                if (this.equalsDefined || !ReflectionUtils.isEqualsMethod(method)) break block16;
                                                bl = this.equals(args[0]);
                                                if (target == null || targetSource.isStatic()) break block17;
                                            }
                                            catch (Throwable throwable) {
                                                if (target != null && !targetSource.isStatic()) {
                                                    targetSource.releaseTarget(target);
                                                }
                                                if (setProxyContext) {
                                                    AopContext.setCurrentProxy(oldProxy);
                                                }
                                                throw throwable;
                                            }
                                            targetSource.releaseTarget(target);
                                        }
                                        if (setProxyContext) {
                                            AopContext.setCurrentProxy(oldProxy);
                                        }
                                        return bl;
                                    }
                                    if (this.hashCodeDefined || !ReflectionUtils.isHashCodeMethod(method)) break block18;
                                    n = this.hashCode();
                                    if (target == null || targetSource.isStatic()) break block19;
                                    targetSource.releaseTarget(target);
                                }
                                if (setProxyContext) {
                                    AopContext.setCurrentProxy(oldProxy);
                                }
                                return n;
                            }
                            if (method.getDeclaringClass() != DecoratingProxy.class) break block20;
                            clazz = AopProxyUtils.ultimateTargetClass(this.advised);
                            if (target == null || targetSource.isStatic()) break block21;
                            targetSource.releaseTarget(target);
                        }
                        if (setProxyContext) {
                            AopContext.setCurrentProxy(oldProxy);
                        }
                        return clazz;
                    }
                    if (advised.isOpaque() || !method.getDeclaringClass().isInterface() || !method.getDeclaringClass().isAssignableFrom(Advised.class)) break block22;
                    object2 = AopUtils.invokeJoinpointUsingReflection(advised, method, args);
                    if (target == null || targetSource.isStatic()) break block23;
                    targetSource.releaseTarget(target);
                }
                if (setProxyContext) {
                    AopContext.setCurrentProxy(oldProxy);
                }
                return object2;
            }
            if (advised.isExposeProxy()) {
                oldProxy = AopContext.setCurrentProxy(proxy);
                setProxyContext = true;
            }
            if (ObjectUtils.isEmpty(chain = advised.getInterceptors(method, targetClass = (target = targetSource.getTarget()) != null ? target.getClass() : null))) {
                Object[] argsToUse = ClassUtils.adaptArgumentsIfNecessary(method, args);
                retVal = AopUtils.invokeJoinpointUsingReflection(target, method, argsToUse);
            } else {
                retVal = new DefaultMethodInvocation(target, method, targetClass, args, (MethodInterceptor[])chain).proceed();
            }
            object = JdkDynamicAopProxy.processReturnValue(proxy, target, method, retVal);
            if (target == null || targetSource.isStatic()) break block24;
            targetSource.releaseTarget(target);
        }
        if (setProxyContext) {
            AopContext.setCurrentProxy(oldProxy);
        }
        return object;
    }

    private static Object processReturnValue(Object proxy, Object target, Method method, Object retVal) {
        Class<?> returnType;
        if (retVal != null && retVal == target && (returnType = method.getReturnType()) != Object.class && returnType.isInstance(proxy)) {
            retVal = proxy;
        }
        if (retVal == null && (returnType = method.getReturnType()) != Void.TYPE && returnType.isPrimitive()) {
            throw new AopInvocationException("Null return value from advice does not match primitive return type for: " + method);
        }
        return retVal;
    }

    public boolean equals(Object other) {
        JdkDynamicAopProxy otherProxy;
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof JdkDynamicAopProxy) {
            otherProxy = (JdkDynamicAopProxy)other;
        } else if (Proxy.isProxyClass(other.getClass())) {
            InvocationHandler ih = Proxy.getInvocationHandler(other);
            if (!(ih instanceof JdkDynamicAopProxy)) {
                return false;
            }
            otherProxy = (JdkDynamicAopProxy)ih;
        } else {
            return false;
        }
        return AopProxyUtils.equalsInProxy(this.advised, otherProxy.advised);
    }

    public int hashCode() {
        return JdkDynamicAopProxy.class.hashCode() * 13 + this.advised.getTargetSource().hashCode();
    }
}

