/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.proxy;

import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.proxy.AbstractSubclassesAopProxy;
import cn.taketoday.aop.proxy.Advised;
import cn.taketoday.aop.proxy.AdvisedSupport;
import cn.taketoday.aop.proxy.AopProxy;
import cn.taketoday.aop.proxy.AopProxyUtils;
import cn.taketoday.aop.proxy.TargetInvocation;
import cn.taketoday.aop.proxy.std.DefaultProxyMethodGenerator;
import cn.taketoday.aop.proxy.std.GeneratorContext;
import cn.taketoday.aop.proxy.std.NoneProxyMethodGenerator;
import cn.taketoday.aop.proxy.std.ProxyMethodGenerator;
import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.AbstractClassGenerator;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.CodeGenerationException;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.KeyFactory;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.TypeUtils;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.ClassUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class StandardAopProxy
extends AbstractSubclassesAopProxy
implements AopProxy {
    private static final Logger log = LoggerFactory.getLogger(StandardAopProxy.class);
    private static final AopKey KEY_FACTORY = KeyFactory.create(AopKey.class, KeyFactory.CLASS_BY_NAME);

    public StandardAopProxy(AdvisedSupport config) {
        super(config);
    }

    @Override
    public Object getProxy(ClassLoader classLoader, Function<Constructor<?>, Object[]> argsFunction) {
        if (log.isDebugEnabled()) {
            log.debug("Creating standard proxy: {}", (Object)this.config.getTargetSource());
        }
        return super.getProxy(classLoader, argsFunction);
    }

    @Override
    protected Object getProxyInternal(Class<?> proxySuperClass, ClassLoader classLoader, Function<Constructor<?>, Object[]> argsFunction) {
        StandardProxyGenerator proxyGenerator = new StandardProxyGenerator(this.config, proxySuperClass, argsFunction);
        proxyGenerator.setClassLoader(classLoader);
        return proxyGenerator.create();
    }

    static class StandardProxyGenerator
    extends AbstractClassGenerator<Object> {
        static final int field_access = 18;
        private static final Signature getTarget;
        private static final Type targetSourceType;
        private static final Type advisedSupportType;
        private static final Type targetInvocationType;
        private Class<?>[] parameterTypes;
        private final AdvisedSupport config;
        private final TargetSource targetSource;
        private final Class<?> targetClass;
        private Constructor<?> constructor;
        final Function<Constructor<?>, Object[]> constructorArgsFunction;
        static List<ProxyMethodGenerator> methodGenerators;

        public StandardProxyGenerator(AdvisedSupport config, Class<?> proxySuperClass, Function<Constructor<?>, Object[]> constructorArgsFunction) {
            super("Aop");
            this.config = config;
            this.targetClass = proxySuperClass;
            this.targetSource = config.getTargetSource();
            this.constructorArgsFunction = constructorArgsFunction;
        }

        public TargetSource getTargetSource() {
            return this.targetSource;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.targetClass.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return CglibReflectUtils.getProtectionDomain(this.targetClass);
        }

        public Object create() {
            this.setUseCache(false);
            this.setNamePrefix(this.targetClass.getName());
            Object key = KEY_FACTORY.newInstance(this.targetClass);
            return super.create(key);
        }

        public Class<?>[] getParameterTypes() {
            if (this.parameterTypes == null) {
                if (this.constructor == null) {
                    this.constructor = ClassUtils.getSuitableConstructor(this.targetClass);
                    if (this.constructor == null) {
                        throw new CodeGenerationException("No suitable constructor found in class: [" + this.targetClass + "]");
                    }
                }
                this.parameterTypes = this.constructor.getParameterTypes();
            }
            return this.parameterTypes;
        }

        @Override
        protected Object firstInstance(Class<Object> type) throws Exception {
            boolean targetSourceStatic = this.targetSource.isStatic();
            Class<?>[] types = this.getParameterTypes();
            int superLength = types.length;
            Class[] argTypes = new Class[superLength + (targetSourceStatic ? 3 : 2)];
            System.arraycopy(types, 0, argTypes, 0, superLength);
            int offset = 0;
            if (targetSourceStatic) {
                argTypes[superLength] = this.targetClass;
                offset = 1;
            }
            argTypes[superLength + offset] = TargetSource.class;
            argTypes[superLength + offset + 1] = AdvisedSupport.class;
            Object[] args = this.createArgs(argTypes);
            if (targetSourceStatic) {
                args[superLength] = this.targetSource.getTarget();
            }
            args[superLength + offset] = this.targetSource;
            args[superLength + offset + 1] = this.config;
            return CglibReflectUtils.newInstance(type, argTypes, args);
        }

        Object[] createArgs(Class<?>[] proxyConstructorArgTypes) {
            Object[] args;
            Object[] ret = new Object[proxyConstructorArgTypes.length];
            if (this.constructorArgsFunction != null && (args = this.constructorArgsFunction.apply(this.constructor)) != null) {
                System.arraycopy(args, 0, ret, 0, args.length);
            }
            return ret;
        }

        @Override
        protected Object nextInstance(Object instance) {
            return instance;
        }

        @Override
        public void generateClass(ClassVisitor v) {
            ClassEmitter ce = new ClassEmitter(v);
            Type targetType = TypeUtils.parseType(this.targetClass);
            Class<?>[] proxiedInterfaces = AopProxyUtils.completeProxiedInterfaces(this.config);
            Type[] interfaces = TypeUtils.getTypes(proxiedInterfaces);
            ce.beginClass(52, 17, this.getClassName(), targetType, interfaces, "<aopGenerated>");
            boolean targetSourceStatic = this.targetSource.isStatic();
            if (targetSourceStatic) {
                ce.declare_field(18, "target", targetType, null);
            }
            ce.declare_field(18, "config", advisedSupportType, null);
            ce.declare_field(18, "targetSource", targetSourceType, null);
            this.generateConstructor(ce, targetType, targetSourceStatic);
            GeneratorContext context = new GeneratorContext(targetType, this.config, ce, this.targetClass);
            for (Method method : this.targetClass.getDeclaredMethods()) {
                if (!this.shouldGenerate(method)) continue;
                for (ProxyMethodGenerator methodGenerator : methodGenerators) {
                    if (methodGenerator.generate(method, context)) break;
                }
            }
            if (!this.config.isOpaque()) {
                for (Method method : Advised.class.getMethods()) {
                    this.generateAdvisedMethod(ce, method);
                }
            }
            this.generateStaticBlock(ce, context);
            ce.endClass();
        }

        protected void generateStaticBlock(ClassEmitter ce, GeneratorContext context) {
            List<String> fields = context.getFields();
            if (!fields.isEmpty()) {
                CodeEmitter staticBlock = ce.begin_static(false);
                for (String target : fields) {
                    staticBlock.visitLdcInsn(target);
                    staticBlock.invoke_static(targetInvocationType, getTarget);
                    staticBlock.putfield(target);
                }
            }
        }

        protected boolean shouldGenerate(Method method) {
            if (method.getName().equals("finalize")) {
                return false;
            }
            int modifiers = method.getModifiers();
            return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && !Modifier.isNative(modifiers) && !Modifier.isPrivate(modifiers);
        }

        protected void generateConstructor(ClassEmitter ce, Type targetType, boolean targetSourceStatic) {
            Type[] superTypes = TypeUtils.getTypes(this.getParameterTypes());
            Type[] types = (Type[])superTypes.clone();
            int typesLength = types.length;
            if (targetSourceStatic) {
                types = TypeUtils.add(types, targetType, true);
            }
            types = TypeUtils.add(types, targetSourceType, advisedSupportType);
            Signature parseConstructor = TypeUtils.parseConstructor(types);
            CodeEmitter code = ce.beginMethod(1, parseConstructor, new Type[0]);
            code.load_this();
            code.dup();
            if (typesLength > 0) {
                code.load_args(0, typesLength);
            }
            code.super_invoke_constructor(TypeUtils.parseConstructor(superTypes));
            int offset = 0;
            if (targetSourceStatic) {
                code.load_this();
                code.load_arg(typesLength);
                code.putfield("target");
                offset = 1;
            }
            code.load_this();
            code.load_arg(typesLength + offset);
            code.putfield("targetSource");
            code.load_this();
            code.load_arg(typesLength + offset + 1);
            code.putfield("config");
            code.return_value();
            code.end_method();
        }

        public void generateAdvisedMethod(ClassEmitter ce, Method method) {
            MethodInfo methodInfo = CglibReflectUtils.getMethodInfo(method, 17);
            CodeEmitter codeEmitter = EmitUtils.beginMethod(ce, methodInfo, 17);
            codeEmitter.load_this();
            codeEmitter.getfield("config");
            codeEmitter.load_args();
            codeEmitter.invoke(methodInfo);
            codeEmitter.return_value();
            codeEmitter.unbox_or_zero(Type.getType(method.getReturnType()));
            codeEmitter.end_method();
        }

        static {
            targetSourceType = Type.getType(TargetSource.class);
            advisedSupportType = Type.getType(AdvisedSupport.class);
            targetInvocationType = Type.getType(TargetInvocation.class);
            try {
                getTarget = new Signature(TargetInvocation.class.getDeclaredMethod("getTarget", String.class));
            }
            catch (NoSuchMethodException e) {
                throw new CodeGenerationException(e);
            }
            methodGenerators = new ArrayList<ProxyMethodGenerator>(2);
            methodGenerators.add(new NoneProxyMethodGenerator());
            methodGenerators.add(new DefaultProxyMethodGenerator());
        }
    }

    static interface AopKey {
        public Object newInstance(Class<?> var1);
    }
}

