/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.proxy;

import cn.taketoday.aop.proxy.AbstractMethodInvocation;
import cn.taketoday.aop.proxy.TargetInvocation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.aopalliance.intercept.MethodInvocation;

public class StandardMethodInvocation
extends AbstractMethodInvocation
implements MethodInvocation {
    protected Object[] args;
    protected final Object bean;
    protected final TargetInvocation target;
    protected int currentAdviceIndex = 0;

    public StandardMethodInvocation(Object bean, TargetInvocation target, Object[] arguments) {
        this.bean = bean;
        this.target = target;
        this.args = arguments;
    }

    @Override
    public Method getMethod() {
        return this.target.getMethod();
    }

    @Override
    public Object[] getArguments() {
        return this.args;
    }

    @Override
    protected void setArguments(Object[] arguments) {
        this.args = arguments;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.target.getTargetClass();
    }

    @Override
    protected Object invokeJoinPoint() {
        return this.target.proceed(this.bean, this.args);
    }

    @Override
    protected boolean hasInterceptor() {
        return this.currentAdviceIndex < this.target.getAdviceLength();
    }

    @Override
    protected Object executeInterceptor() throws Throwable {
        return this.target.invokeAdvice(this, this.currentAdviceIndex++);
    }

    @Override
    public Object getThis() {
        return this.bean;
    }

    @Override
    public AccessibleObject getStaticPart() {
        return this.target.getMethod();
    }

    public String toString() {
        return this.target.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StandardMethodInvocation)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StandardMethodInvocation that = (StandardMethodInvocation)o;
        return this.currentAdviceIndex == that.currentAdviceIndex && Objects.equals(this.target, that.target) && Arrays.equals(this.args, that.args);
    }

    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.target, this.currentAdviceIndex);
        result = 31 * result + Arrays.hashCode(this.args);
        return result;
    }
}

