/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support;

import cn.taketoday.aop.ClassFilter;
import cn.taketoday.aop.DynamicIntroductionAdvice;
import cn.taketoday.aop.IntroductionAdvisor;
import cn.taketoday.aop.IntroductionInfo;
import cn.taketoday.context.Ordered;
import cn.taketoday.context.OrderedSupport;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ObjectUtils;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.aopalliance.aop.Advice;

public class DefaultIntroductionAdvisor
extends OrderedSupport
implements IntroductionAdvisor,
ClassFilter,
Ordered,
Serializable {
    private final Advice advice;
    private final Set<Class<?>> interfaces = new LinkedHashSet();

    public DefaultIntroductionAdvisor(Advice advice) {
        this(advice, advice instanceof IntroductionInfo ? (IntroductionInfo)((Object)advice) : null);
    }

    public DefaultIntroductionAdvisor(Advice advice, IntroductionInfo introductionInfo) {
        Assert.notNull((Object)advice, "Advice must not be null");
        this.advice = advice;
        if (introductionInfo != null) {
            Object[] introducedInterfaces = introductionInfo.getInterfaces();
            if (ObjectUtils.isEmpty(introducedInterfaces)) {
                throw new IllegalArgumentException("IntroductionAdviceSupport implements no interfaces");
            }
            for (Object ifc : introducedInterfaces) {
                this.addInterface((Class<?>)ifc);
            }
        }
    }

    public DefaultIntroductionAdvisor(DynamicIntroductionAdvice advice, Class<?> ifc) {
        Assert.notNull((Object)advice, "Advice must not be null");
        this.advice = advice;
        this.addInterface(ifc);
    }

    public void addInterface(Class<?> ifc) {
        Assert.notNull(ifc, "Interface must not be null");
        if (!ifc.isInterface()) {
            throw new IllegalArgumentException("Specified class [" + ifc.getName() + "] must be an interface");
        }
        this.interfaces.add(ifc);
    }

    @Override
    public Class<?>[] getInterfaces() {
        return ClassUtils.toClassArray(this.interfaces);
    }

    @Override
    public void validateInterfaces() {
        for (Class<?> ifc : this.interfaces) {
            if (!(this.advice instanceof DynamicIntroductionAdvice) || ((DynamicIntroductionAdvice)this.advice).implementsInterface(ifc)) continue;
            throw new IllegalArgumentException("DynamicIntroductionAdvice [" + this.advice + "] does not implement interface [" + ifc.getName() + "] specified for introduction");
        }
    }

    @Override
    public Advice getAdvice() {
        return this.advice;
    }

    @Override
    public ClassFilter getClassFilter() {
        return this;
    }

    @Override
    public boolean matches(Class<?> clazz) {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefaultIntroductionAdvisor)) {
            return false;
        }
        DefaultIntroductionAdvisor otherAdvisor = (DefaultIntroductionAdvisor)other;
        return this.advice.equals(otherAdvisor.advice) && this.interfaces.equals(otherAdvisor.interfaces);
    }

    public int hashCode() {
        return this.advice.hashCode() * 13 + this.interfaces.hashCode();
    }

    public String toString() {
        return ObjectUtils.toHexString(this) + ": advice [" + this.advice + "]; interfaces " + ClassUtils.classNamesToString(this.interfaces);
    }
}

