/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support;

import cn.taketoday.aop.DynamicIntroductionAdvice;
import cn.taketoday.aop.IntroductionInterceptor;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.aop.support.IntroductionInfoSupport;
import cn.taketoday.context.utils.Assert;
import org.aopalliance.intercept.MethodInvocation;

public class DelegatingIntroductionInterceptor
extends IntroductionInfoSupport
implements IntroductionInterceptor {
    private static final long serialVersionUID = 1L;
    private Object delegate;

    public DelegatingIntroductionInterceptor(Object delegate) {
        this.init(delegate);
    }

    protected DelegatingIntroductionInterceptor() {
        this.init(this);
    }

    private void init(Object delegate) {
        Assert.notNull(delegate, "Delegate must not be null");
        this.delegate = delegate;
        this.implementInterfacesOnObject(delegate);
        this.suppressInterface(IntroductionInterceptor.class);
        this.suppressInterface(DynamicIntroductionAdvice.class);
    }

    @Override
    public Object invoke(MethodInvocation mi) throws Throwable {
        if (this.isMethodOnIntroducedInterface(mi)) {
            return AopUtils.invokeJoinpointUsingReflection(this.delegate, mi.getMethod(), mi.getArguments());
        }
        return this.doProceed(mi);
    }

    protected Object doProceed(MethodInvocation mi) throws Throwable {
        return mi.proceed();
    }
}

