/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support;

import cn.taketoday.context.factory.ObjectSupplier;
import cn.taketoday.context.utils.Assert;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public final class SuppliedMethodInterceptor
implements MethodInterceptor {
    final ObjectSupplier<MethodInterceptor> supplier;

    public SuppliedMethodInterceptor(ObjectSupplier<MethodInterceptor> interceptorSupplier) {
        Assert.notNull(interceptorSupplier, "interceptorSupplier must not be null");
        this.supplier = interceptorSupplier;
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        MethodInterceptor interceptor = this.supplier.getIfAvailable();
        Assert.state(interceptor != null, "No MethodInterceptor");
        return interceptor.invoke(invocation);
    }
}

