/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support.annotation;

import cn.taketoday.aop.support.annotation.Annotated;
import cn.taketoday.aop.support.annotation.Argument;
import cn.taketoday.aop.support.annotation.Arguments;
import cn.taketoday.aop.support.annotation.Attribute;
import cn.taketoday.aop.support.annotation.JoinPoint;
import cn.taketoday.aop.support.annotation.Returning;
import cn.taketoday.aop.support.annotation.Throwing;
import cn.taketoday.context.AttributeAccessor;
import cn.taketoday.context.Ordered;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.ObjectSupplier;
import cn.taketoday.context.reflect.MethodInvoker;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ExceptionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.Joinpoint;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public abstract class AbstractAnnotationMethodInterceptor
implements Advice,
MethodInterceptor,
Ordered {
    private final MethodInvoker invoker;
    private final byte[] adviceParameters;
    private final int adviceParameterLength;
    private final Class<?>[] adviceParameterTypes;
    final ObjectSupplier<Object> aspectSupplier;

    public AbstractAnnotationMethodInterceptor(Method adviceMethod, BeanFactory beanFactory, BeanDefinition aspectDef) {
        Assert.notNull((Object)beanFactory, "beanFactory must not be null");
        Assert.notNull((Object)adviceMethod, "adviceMethod must not be null");
        Assert.notNull((Object)aspectDef, "aspect bean definition must not be null");
        this.aspectSupplier = beanFactory.getBeanSupplier(aspectDef);
        this.invoker = MethodInvoker.create(adviceMethod, aspectDef.getBeanClass());
        this.adviceParameterLength = adviceMethod.getParameterCount();
        this.adviceParameters = new byte[this.adviceParameterLength];
        this.adviceParameterTypes = adviceMethod.getParameterTypes();
        Parameter[] parameters = adviceMethod.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            this.adviceParameters[i] = 0;
            if (parameter.isAnnotationPresent(JoinPoint.class)) {
                this.adviceParameters[i] = 6;
            }
            if (parameter.isAnnotationPresent(Argument.class)) {
                this.adviceParameters[i] = 2;
            }
            if (parameter.isAnnotationPresent(Arguments.class)) {
                this.adviceParameters[i] = 3;
            }
            if (parameter.isAnnotationPresent(Returning.class)) {
                this.adviceParameters[i] = 4;
            }
            if (parameter.isAnnotationPresent(Throwing.class)) {
                this.adviceParameters[i] = 1;
            }
            if (parameter.isAnnotationPresent(Annotated.class)) {
                this.adviceParameters[i] = 5;
            }
            if (!parameter.isAnnotationPresent(Attribute.class)) continue;
            this.adviceParameters[i] = 7;
        }
    }

    @Override
    public abstract Object invoke(MethodInvocation var1) throws Throwable;

    protected Object invokeAdviceMethod(MethodInvocation inv, Object returnValue, Throwable throwable) {
        if (this.adviceParameterLength == 0) {
            return this.invoker.invoke(this.obtainAspectInstance(), null);
        }
        int idx = 0;
        Object[] args = new Object[this.adviceParameterLength];
        Class<?>[] adviceParameterTypes = this.adviceParameterTypes;
        for (byte adviceParameter : this.adviceParameters) {
            block0 : switch (adviceParameter) {
                case 1: {
                    if (throwable == null) break;
                    Class<?> parameterType = adviceParameterTypes[idx];
                    throwable = ExceptionUtils.unwrapThrowable(throwable);
                    if (parameterType != Throwable.class && !parameterType.isAssignableFrom(throwable.getClass())) break;
                    args[idx] = throwable;
                    break;
                }
                case 2: {
                    Object[] arguments = inv.getArguments();
                    if (arguments.length == 1) {
                        args[idx] = arguments[0];
                        break;
                    }
                    for (Object argument : arguments) {
                        if (argument == null || argument.getClass() != adviceParameterTypes[idx]) continue;
                        args[idx] = argument;
                        break block0;
                    }
                    break;
                }
                case 7: {
                    Class<?> parameterType;
                    if (inv instanceof AttributeAccessor) {
                        parameterType = adviceParameterTypes[idx];
                        if (AttributeAccessor.class == parameterType || MethodInvocation.class == parameterType) {
                            args[idx] = inv;
                            break;
                        }
                        if (Map.class == parameterType || HashMap.class == parameterType) {
                            args[idx] = ((AttributeAccessor)((Object)inv)).getAttributes();
                            break;
                        }
                        throw new ConfigurationException("Not supported " + parameterType);
                    }
                    throw new ConfigurationException("Not supported " + inv);
                }
                case 3: {
                    args[idx] = inv.getArguments();
                    break;
                }
                case 4: {
                    args[idx] = returnValue;
                    break;
                }
                case 5: {
                    args[idx] = this.resolveAnnotation(inv, adviceParameterTypes[idx]);
                    break;
                }
                case 6: {
                    args[idx] = inv;
                    break;
                }
                default: {
                    Class<?> parameterType = adviceParameterTypes[idx];
                    if (Joinpoint.class.isAssignableFrom(parameterType)) {
                        args[idx] = inv;
                        break;
                    }
                    if (Annotation.class.isAssignableFrom(parameterType)) {
                        args[idx] = this.resolveAnnotation(inv, parameterType);
                        break;
                    }
                    if (throwable != null) {
                        throwable = ExceptionUtils.unwrapThrowable(throwable);
                        if (parameterType == Throwable.class || parameterType.isAssignableFrom(throwable.getClass())) {
                            args[idx] = throwable;
                            break;
                        }
                    } else {
                        if (returnValue != null && parameterType.isAssignableFrom(returnValue.getClass())) {
                            args[idx] = returnValue;
                            break;
                        }
                        if (inv instanceof AttributeAccessor) {
                            if (AttributeAccessor.class == parameterType || MethodInvocation.class == parameterType) {
                                args[idx] = inv;
                                break;
                            }
                            if (Map.class == parameterType || HashMap.class == parameterType) {
                                args[idx] = ((AttributeAccessor)((Object)inv)).getAttributes();
                                break;
                            }
                        }
                    }
                    throw new ConfigurationException("Not supported " + parameterType);
                }
            }
            ++idx;
        }
        return this.invoker.invoke(this.obtainAspectInstance(), args);
    }

    private Object resolveAnnotation(MethodInvocation methodInvocation, Class annotationClass) {
        Method method = methodInvocation.getMethod();
        Object annotation = ClassUtils.getAnnotation(annotationClass, method);
        if (annotation == null) {
            annotation = ClassUtils.getAnnotation(annotationClass, method.getDeclaringClass());
        }
        return annotation;
    }

    private Object obtainAspectInstance() {
        return this.aspectSupplier.get();
    }
}

