/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support.annotation;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.proxy.DefaultAutoProxyCreator;
import cn.taketoday.aop.support.AnnotationMatchingPointcut;
import cn.taketoday.aop.support.DefaultPointcutAdvisor;
import cn.taketoday.aop.support.SuppliedMethodInterceptor;
import cn.taketoday.aop.support.annotation.AbstractAnnotationMethodInterceptor;
import cn.taketoday.aop.support.annotation.Advice;
import cn.taketoday.aop.support.annotation.Aspect;
import cn.taketoday.context.AnnotationAttributes;
import cn.taketoday.context.annotation.Component;
import cn.taketoday.context.event.ApplicationListener;
import cn.taketoday.context.event.ContextCloseEvent;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.factory.AutowireCapableBeanFactory;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanDefinitionRegistry;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.ObjectSupplier;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.context.utils.OrderUtils;
import cn.taketoday.context.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;

public class AspectAutoProxyCreator
extends DefaultAutoProxyCreator
implements ApplicationListener<ContextCloseEvent> {
    private static final long serialVersionUID = 1L;
    private boolean aspectsLoaded;
    private final List<BeanDefinition> aspectDefs = new ArrayList<BeanDefinition>();

    public void sortAspects() {
        OrderUtils.reversedSort(this.aspectDefs);
    }

    public boolean isAspectsLoaded() {
        return this.aspectsLoaded;
    }

    public void setAspectsLoaded(boolean aspectsLoaded) {
        this.aspectsLoaded = aspectsLoaded;
    }

    public void loadAspects(BeanFactory beanFactory) {
        this.log.info("Loading aspect bean definitions");
        this.setAspectsLoaded(true);
        for (BeanDefinition beanDefinition : beanFactory.getBeanDefinitions().values()) {
            if (!beanDefinition.isAnnotationPresent(Aspect.class)) continue;
            String aspectName = beanDefinition.getName();
            this.log.info("Found Aspect: [{}]", (Object)aspectName);
            this.aspectDefs.add(beanDefinition);
        }
        this.sortAspects();
    }

    @Override
    public void onApplicationEvent(ContextCloseEvent event) {
        this.log.info("Removing aspects");
        this.aspectDefs.clear();
        this.setAspectsLoaded(false);
    }

    private void loadAspects() {
        if (!this.aspectsLoaded) {
            this.loadAspects(this.getBeanFactory());
        }
    }

    @Override
    protected void addCandidateAdvisors(List<Advisor> candidateAdvisors) {
        super.addCandidateAdvisors(candidateAdvisors);
        this.loadAspects();
        for (BeanDefinition aspectDef : this.aspectDefs) {
            Method[] declaredMethods;
            Class<?> aspectClass = aspectDef.getBeanClass();
            if (MethodInterceptor.class.isAssignableFrom(aspectClass)) {
                AnnotationAttributes[] adviceAttributes = this.getAdviceAttributes(aspectDef);
                this.addCandidateAdvisors(candidateAdvisors, aspectDef, null, adviceAttributes);
            }
            for (Method aspectMethod : declaredMethods = ReflectionUtils.getDeclaredMethods(aspectClass)) {
                AnnotationAttributes[] adviceAttributes = this.getAdviceAttributes(aspectMethod);
                this.addCandidateAdvisors(candidateAdvisors, aspectDef, aspectMethod, adviceAttributes);
            }
        }
    }

    private void addCandidateAdvisors(List<Advisor> candidateAdvisors, BeanDefinition aspectDef, Method aspectMethod, AnnotationAttributes[] adviceAttributes) {
        if (ObjectUtils.isNotEmpty(adviceAttributes)) {
            for (AnnotationAttributes advice : adviceAttributes) {
                Object[] annotations;
                MethodInterceptor interceptor = this.getInterceptor(aspectDef, aspectMethod, advice);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Found Interceptor: [{}]", (Object)interceptor);
                }
                if (!ObjectUtils.isNotEmpty(annotations = advice.getClassArray("value"))) continue;
                for (Object annotation : annotations) {
                    AnnotationMatchingPointcut matchingPointcut = AnnotationMatchingPointcut.forMethodAnnotation((Class<? extends Annotation>)annotation);
                    DefaultPointcutAdvisor pointcutAdvisor = new DefaultPointcutAdvisor(matchingPointcut, interceptor);
                    candidateAdvisors.add(pointcutAdvisor);
                }
            }
        }
    }

    private MethodInterceptor getInterceptor(BeanDefinition aspectDef, Method aspectMethod, AnnotationAttributes advice) {
        MethodInterceptor ret;
        BeanFactory beanFactory = this.getBeanFactory();
        if (aspectMethod == null) {
            if (!MethodInterceptor.class.isAssignableFrom(aspectDef.getBeanClass())) {
                throw new ConfigurationException('[' + aspectDef.getBeanClass().getName() + "] must be implement: [" + MethodInterceptor.class.getName() + ']');
            }
            return this.getMethodInterceptor(beanFactory, aspectDef);
        }
        Class interceptor = advice.getClass("interceptor");
        if (interceptor == AbstractAnnotationMethodInterceptor.class || !MethodInterceptor.class.isAssignableFrom(interceptor)) {
            throw new ConfigurationException("You must be implement: [" + AbstractAnnotationMethodInterceptor.class.getName() + "] or [" + MethodInterceptor.class.getName() + "]");
        }
        if (ClassUtils.isAnnotationPresent(interceptor, Component.class)) {
            if (beanFactory instanceof BeanDefinitionRegistry) {
                BeanDefinition interceptorDef = ((BeanDefinitionRegistry)((Object)beanFactory)).getBeanDefinition(interceptor);
                if (interceptorDef != null) {
                    return this.getMethodInterceptor(beanFactory, interceptorDef);
                }
            } else {
                ret = (MethodInterceptor)beanFactory.getBean(interceptor);
                if (ret != null) {
                    return ret;
                }
            }
        }
        ret = (MethodInterceptor)ClassUtils.newInstance(interceptor, beanFactory, new Object[]{aspectMethod, aspectDef, beanFactory});
        if (beanFactory instanceof AutowireCapableBeanFactory) {
            ((AutowireCapableBeanFactory)beanFactory).autowireBean(ret);
        }
        return ret;
    }

    private MethodInterceptor getMethodInterceptor(BeanFactory beanFactory, BeanDefinition interceptorDef) {
        if (interceptorDef.isSingleton() && !interceptorDef.isLazyInit()) {
            return (MethodInterceptor)beanFactory.getBean(interceptorDef);
        }
        ObjectSupplier<MethodInterceptor> supplier = beanFactory.getBeanSupplier(interceptorDef);
        return new SuppliedMethodInterceptor(supplier);
    }

    private AnnotationAttributes[] getAdviceAttributes(AnnotatedElement annotated) {
        return ClassUtils.getAnnotationAttributesArray(annotated, Advice.class);
    }
}

