/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.target;

import cn.taketoday.aop.TargetSource;
import cn.taketoday.context.aware.BeanFactoryAware;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanDefinitionRegistry;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.Assert;
import java.io.Serializable;
import java.util.Objects;

public abstract class AbstractBeanFactoryTargetSource
implements TargetSource,
BeanFactoryAware,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String targetBeanName;
    private volatile Class<?> targetClass;
    private BeanFactory beanFactory;
    private BeanDefinition targetBeanDefinition;

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    public String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setTargetClass(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (this.targetBeanDefinition == null && this.targetBeanName != null) {
            this.targetBeanDefinition = beanFactory instanceof BeanDefinitionRegistry ? ((BeanDefinitionRegistry)((Object)beanFactory)).getBeanDefinition(this.targetBeanName) : beanFactory.getBeanDefinitions().get(this.targetBeanName);
        }
        this.beanFactory = beanFactory;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setTargetBeanDefinition(BeanDefinition targetBeanDefinition) {
        if (this.targetBeanName == null && targetBeanDefinition != null) {
            this.targetBeanName = targetBeanDefinition.getName();
        }
        this.targetBeanDefinition = targetBeanDefinition;
    }

    public BeanDefinition getTargetBeanDefinition() {
        BeanDefinition definition = this.targetBeanDefinition;
        if (definition == null) {
            Assert.state(this.targetBeanName != null, "Property 'targetBeanName' is required");
            definition = this.beanFactory instanceof BeanDefinitionRegistry ? ((BeanDefinitionRegistry)((Object)this.beanFactory)).getBeanDefinition(this.targetBeanName) : this.beanFactory.getBeanDefinitions().get(this.targetBeanName);
            Assert.state(definition != null, "Property 'targetBeanDefinition' is required");
            this.targetBeanDefinition = definition;
        }
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getTargetClass() {
        Class<?> targetClass = this.targetClass;
        if (targetClass != null) {
            return targetClass;
        }
        AbstractBeanFactoryTargetSource abstractBeanFactoryTargetSource = this;
        synchronized (abstractBeanFactoryTargetSource) {
            targetClass = this.targetClass;
            if (targetClass == null) {
                targetClass = this.getTargetBeanDefinition().getBeanClass();
            }
            return targetClass;
        }
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    protected void copyFrom(AbstractBeanFactoryTargetSource other) {
        this.targetClass = other.targetClass;
        this.beanFactory = other.beanFactory;
        this.targetBeanName = other.targetBeanName;
        this.targetBeanDefinition = other.targetBeanDefinition;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractBeanFactoryTargetSource otherTarget = (AbstractBeanFactoryTargetSource)other;
        return Objects.equals(this.beanFactory, otherTarget.beanFactory) && Objects.equals(this.targetBeanName, otherTarget.targetBeanName);
    }

    public int hashCode() {
        int hashCode = this.getClass().hashCode();
        hashCode = 13 * hashCode + Objects.hashCode(this.beanFactory);
        hashCode = 13 * hashCode + Objects.hashCode(this.targetBeanName);
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" for target bean '").append(this.targetBeanName).append("'");
        if (this.targetClass != null) {
            sb.append(" of type [").append(this.targetClass.getName()).append("]");
        }
        return sb.toString();
    }
}

