/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.target;

import cn.taketoday.aop.target.AbstractBeanFactoryTargetSource;
import cn.taketoday.aop.target.EmptyTargetSource;
import cn.taketoday.aop.target.SingletonTargetSource;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.ConfigurableBeanFactory;
import cn.taketoday.context.factory.DisposableBean;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;

public abstract class AbstractPrototypeTargetSource
extends AbstractBeanFactoryTargetSource {
    protected Object newPrototypeInstance() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating new instance of bean '{}'", (Object)this.getTargetBeanName());
        }
        return this.getBeanFactory().getBean(this.getTargetBeanDefinition());
    }

    protected void destroyPrototypeInstance(Object target) {
        BeanFactory factory;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Destroying instance of bean '{}'", (Object)this.getTargetBeanName());
        }
        if ((factory = this.getBeanFactory()) != null && factory.isFullLifecycle()) {
            if (factory instanceof ConfigurableBeanFactory) {
                ((ConfigurableBeanFactory)factory).destroyBean(target, this.getTargetBeanDefinition());
            } else if (target instanceof DisposableBean) {
                try {
                    ((DisposableBean)target).destroy();
                }
                catch (Throwable ex) {
                    this.logger.warn("Destroy method on bean with name '{}' threw an exception", (Object)this.getTargetBeanName(), (Object)ex);
                }
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        throw new NotSerializableException("A prototype-based TargetSource itself is not deserializable - just a disconnected SingletonTargetSource or EmptyTargetSource is");
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Disconnecting TargetSource [{}]", (Object)this);
        }
        try {
            Object target = this.getTarget();
            return target != null ? new SingletonTargetSource(target) : EmptyTargetSource.forClass(this.getTargetClass());
        }
        catch (Exception ex) {
            String msg = "Cannot get target for disconnecting TargetSource [" + this + "]";
            this.logger.error(msg, ex);
            throw new NotSerializableException(msg + ": " + ex);
        }
    }
}

