/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.target;

import cn.taketoday.aop.TargetSource;
import java.io.Serializable;
import java.util.Objects;

public final class EmptyTargetSource
implements TargetSource,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final EmptyTargetSource INSTANCE = new EmptyTargetSource(null, true);
    private final Class<?> targetClass;
    private final boolean isStatic;

    public static EmptyTargetSource forClass(Class<?> targetClass) {
        return EmptyTargetSource.forClass(targetClass, true);
    }

    public static EmptyTargetSource forClass(Class<?> targetClass, boolean isStatic) {
        return targetClass == null && isStatic ? INSTANCE : new EmptyTargetSource(targetClass, isStatic);
    }

    private EmptyTargetSource(Class<?> targetClass, boolean isStatic) {
        this.targetClass = targetClass;
        this.isStatic = isStatic;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public Object getTarget() {
        return null;
    }

    private Object readResolve() {
        return this.targetClass == null && this.isStatic ? INSTANCE : this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EmptyTargetSource)) {
            return false;
        }
        EmptyTargetSource otherTs = (EmptyTargetSource)other;
        return this.isStatic == otherTs.isStatic && Objects.equals(this.targetClass, otherTs.targetClass);
    }

    public int hashCode() {
        return EmptyTargetSource.class.hashCode() * 13 + Objects.hashCode(this.targetClass);
    }

    public String toString() {
        return "EmptyTargetSource: " + (this.targetClass != null ? "target class [" + this.targetClass.getName() + "]" : "no target class") + ", " + (this.isStatic ? "static" : "dynamic");
    }
}

