/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.target;

import cn.taketoday.aop.TargetSource;
import cn.taketoday.context.utils.Assert;
import java.io.Serializable;
import java.util.Objects;

public class HotSwappableTargetSource
implements TargetSource,
Serializable {
    private static final long serialVersionUID = 1L;
    private Object target;

    public HotSwappableTargetSource(Object initialTarget) {
        Assert.notNull(initialTarget, "Target object must not be null");
        this.target = initialTarget;
    }

    @Override
    public synchronized Class<?> getTargetClass() {
        return this.target.getClass();
    }

    @Override
    public final boolean isStatic() {
        return false;
    }

    @Override
    public synchronized Object getTarget() {
        return this.target;
    }

    public synchronized Object swap(Object newTarget) {
        Assert.notNull(newTarget, "Target object must not be null");
        Object old = this.target;
        this.target = newTarget;
        return old;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof HotSwappableTargetSource && Objects.equals(this.target, ((HotSwappableTargetSource)other).target);
    }

    public int hashCode() {
        return HotSwappableTargetSource.class.hashCode();
    }

    public String toString() {
        return "HotSwappableTargetSource for target: " + this.target;
    }
}

