/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.target;

import cn.taketoday.aop.TargetSource;
import cn.taketoday.context.utils.Assert;
import java.io.Serializable;

public class SingletonTargetSource
implements TargetSource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object target;

    public SingletonTargetSource(Object target) {
        Assert.notNull(target, "Target object must not be null");
        this.target = target;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.target.getClass();
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public void releaseTarget(Object target) {
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SingletonTargetSource)) {
            return false;
        }
        return this.target.equals(((SingletonTargetSource)other).target);
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return "SingletonTargetSource for target object [" + this.target + ']';
    }
}

