/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache;

import cn.taketoday.cache.Cache;
import cn.taketoday.cache.CacheManager;
import cn.taketoday.cache.annotation.CacheConfig;
import cn.taketoday.cache.annotation.CacheConfiguration;
import cn.taketoday.context.utils.Assert;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractCacheManager
implements CacheManager {
    private boolean dynamicCreation = true;
    private final HashMap<String, Cache> cacheMap = new HashMap(32);
    private final HashMap<String, CacheConfig> configMap = new HashMap();

    public AbstractCacheManager() {
    }

    public AbstractCacheManager(String ... cacheNames) {
        Assert.notNull((Object)cacheNames, "cacheNames s can't be null");
        this.setCacheNames(Arrays.asList(cacheNames));
    }

    public AbstractCacheManager(CacheConfig ... config) {
        Assert.notNull((Object)config, "cache config can't be null");
        this.setCacheConfig(Arrays.asList(config));
    }

    public void setCacheNames(Collection<String> cacheNames) {
        Assert.notEmpty(cacheNames, "cacheNames must not be empty");
        this.setCacheConfig(cacheNames.stream().map(CacheConfiguration::new).collect(Collectors.toList()));
    }

    public void setCacheConfig(Collection<CacheConfig> cacheConfigs) {
        Assert.notEmpty(cacheConfigs, "cacheConfigs must not be empty");
        this.configMap.clear();
        for (CacheConfig config : cacheConfigs) {
            this.configMap.put(config.cacheName(), config);
        }
        this.refreshCaches();
    }

    public void setCacheConfig(Map<String, CacheConfig> configMap) {
        Assert.notEmpty(configMap, "configMap must not be empty");
        this.configMap.clear();
        this.configMap.putAll(configMap);
        this.refreshCaches();
    }

    public void addCacheConfig(CacheConfig config) {
        this.addCacheConfig(config.cacheName(), config);
    }

    public void addCacheConfig(String name, CacheConfig config) {
        Assert.notNull((Object)name, "name must not be null");
        Assert.notNull((Object)config, "config must not be null");
        this.configMap.put(name, config);
        this.refreshCache(name, config);
    }

    public void registerCustomCache(Cache cache) {
        this.registerCustomCache(cache.getName(), cache);
    }

    public void registerCustomCache(String name, Cache cache) {
        this.cacheMap.put(name, cache);
    }

    protected Cache createCache(String name) {
        return this.createCache(name, this.getCacheConfig(name));
    }

    protected Cache createCache(String name, CacheConfig cacheConfig) {
        return this.decorateCache(this.doCreate(name, cacheConfig));
    }

    protected Cache decorateCache(Cache cache) {
        return cache;
    }

    protected abstract Cache doCreate(String var1, CacheConfig var2);

    @Override
    public Cache getCache(String name) {
        return this.getCache(name, this.getCacheConfig(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getCache(String name, CacheConfig cacheConfig) {
        Cache cache = this.cacheMap.get(name);
        if (cache == null && this.isDynamicCreation()) {
            HashMap<String, Cache> hashMap = this.cacheMap;
            synchronized (hashMap) {
                cache = this.cacheMap.get(name);
                if (cache == null) {
                    cache = this.createCache(name, cacheConfig);
                    this.configMap.put(name, cacheConfig);
                    this.registerCustomCache(name, cache);
                }
            }
        }
        return cache;
    }

    public boolean isDynamicCreation() {
        return this.dynamicCreation;
    }

    public void setDynamicCreation(boolean dynamicCreation) {
        this.dynamicCreation = dynamicCreation;
    }

    public void refreshCaches() {
        this.configMap.keySet().forEach(this::refreshCache);
    }

    public void refreshCache(String name, CacheConfig config) {
        this.registerCustomCache(name, this.createCache(name, config));
    }

    public void refreshCache(String name) {
        this.registerCustomCache(name, this.createCache(name));
    }

    public final CacheConfig getCacheConfig(String name) {
        CacheConfig cacheConfig = this.configMap.get(name);
        return cacheConfig == null ? CacheConfig.EMPTY_CACHE_CONFIG : cacheConfig;
    }

    @Override
    public Collection<String> getCacheNames() {
        return this.configMap.keySet();
    }

    protected static boolean isDefaultConfig(CacheConfig cacheConfig) {
        if (cacheConfig == null || cacheConfig == CacheConfig.EMPTY_CACHE_CONFIG) {
            return true;
        }
        return cacheConfig.maxIdleTime() == 0L && cacheConfig.expire() == 0L && cacheConfig.maxSize() == 0;
    }
}

