/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.annotation;

import cn.taketoday.cache.annotation.CacheConfig;
import cn.taketoday.cache.annotation.CacheEvict;
import cn.taketoday.cache.annotation.CachePut;
import cn.taketoday.cache.annotation.Cacheable;
import cn.taketoday.context.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;

public class CacheConfiguration
implements Cacheable,
CacheEvict,
CachePut,
CacheConfig,
Annotation {
    private boolean sync = false;
    private boolean allEntries = false;
    private String key = "";
    private String unless = "";
    private boolean beforeInvocation = false;
    private String cacheName = "";
    private String condition = "";
    private int maxSize = 0;
    private long expire = 0L;
    private long maxIdleTime = 0L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private final Class<? extends Annotation> annotationType;

    public CacheConfiguration() {
        this(CacheConfig.class);
    }

    public CacheConfiguration(String name) {
        this(name, CacheConfig.class);
    }

    public CacheConfiguration(Class<? extends Annotation> annotationType) {
        this(null, annotationType);
    }

    public CacheConfiguration(String name, Class<? extends Annotation> annotationType) {
        this.cacheName = name;
        this.annotationType = annotationType;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    @Override
    public String cacheName() {
        return this.cacheName;
    }

    @Override
    public long expire() {
        return this.expire;
    }

    @Override
    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String condition() {
        return this.condition;
    }

    @Override
    public String unless() {
        return this.unless;
    }

    @Override
    public boolean sync() {
        return this.sync;
    }

    @Override
    public boolean allEntries() {
        return this.allEntries;
    }

    @Override
    public boolean beforeInvocation() {
        return this.beforeInvocation;
    }

    public void mergeCacheConfigAttributes(CacheConfig cacheConfig) {
        TimeUnit timeUnit;
        if (StringUtils.isEmpty(this.cacheName)) {
            this.cacheName = cacheConfig.cacheName();
        }
        if (this.expire == 0L) {
            this.expire = cacheConfig.expire();
        }
        if (this.maxSize == 0) {
            this.maxSize = cacheConfig.maxSize();
        }
        if (this.maxIdleTime == 0L) {
            this.maxIdleTime = cacheConfig.maxIdleTime();
        }
        if (this.timeUnit == TimeUnit.MILLISECONDS && (timeUnit = cacheConfig.timeUnit()) != TimeUnit.MILLISECONDS) {
            this.timeUnit = timeUnit;
        }
    }

    @Override
    public int maxSize() {
        return this.maxSize;
    }

    @Override
    public long maxIdleTime() {
        return this.maxIdleTime;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public void setAllEntries(boolean allEntries) {
        this.allEntries = allEntries;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setUnless(String unless) {
        this.unless = unless;
    }

    public void setBeforeInvocation(boolean beforeInvocation) {
        this.beforeInvocation = beforeInvocation;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }
}

