/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.interceptor;

import cn.taketoday.cache.Cache;
import cn.taketoday.cache.CacheExpressionContext;
import cn.taketoday.cache.CacheManager;
import cn.taketoday.cache.DefaultCacheKey;
import cn.taketoday.cache.NoSuchCacheException;
import cn.taketoday.cache.annotation.CacheConfig;
import cn.taketoday.cache.annotation.CacheConfiguration;
import cn.taketoday.cache.interceptor.CacheExceptionResolver;
import cn.taketoday.cache.interceptor.CacheOperations;
import cn.taketoday.context.AnnotationAttributes;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.Ordered;
import cn.taketoday.context.OrderedSupport;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ConcurrentCache;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.expression.ExpressionFactory;
import cn.taketoday.expression.StandardExpressionContext;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public abstract class AbstractCacheInterceptor
extends CacheOperations
implements MethodInterceptor,
Ordered {
    private CacheManager cacheManager;
    private final OrderedSupport ordered = new OrderedSupport();

    public AbstractCacheInterceptor() {
    }

    public AbstractCacheInterceptor(CacheManager cacheManager) {
        this.setCacheManager(cacheManager);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public final CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public int getOrder() {
        return this.ordered.getOrder();
    }

    public void setOrder(int order) {
        this.ordered.setOrder(order);
    }

    protected String prepareCacheName(Method method, String cacheName) {
        if (StringUtils.isEmpty(cacheName)) {
            return method.getDeclaringClass().getName();
        }
        return cacheName;
    }

    protected Cache getCache(String name, CacheConfig cacheConfig) {
        return this.getCacheManager().getCache(name, cacheConfig);
    }

    protected final Cache obtainCache(Method method, CacheConfig cacheConfig) {
        String name = this.prepareCacheName(method, cacheConfig.cacheName());
        Cache cache = this.getCache(name, cacheConfig);
        if (cache == null) {
            throw new NoSuchCacheException(name);
        }
        return cache;
    }

    @PostConstruct
    public void initCacheInterceptor(ApplicationContext context) {
        if (this.getCacheManager() == null) {
            this.setCacheManager(context.getBean(CacheManager.class));
        }
        if (this.getExceptionResolver() == null) {
            this.setExceptionResolver(context.getBean(CacheExceptionResolver.class));
        }
        Assert.state(this.getCacheManager() != null, "You must provide a 'CacheManager'");
        Assert.state(this.getExceptionResolver() != null, "You must provide a 'CacheExceptionResolver'");
    }

    static final class MethodKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int hash;
        private final transient Method targetMethod;
        private final Class<? extends Annotation> annotationClass;

        public MethodKey(Method targetMethod, Class<? extends Annotation> annotationClass) {
            this.targetMethod = targetMethod;
            this.hash = targetMethod.hashCode();
            this.annotationClass = annotationClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodKey)) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            return this.hash == methodKey.hash && Objects.equals(this.targetMethod, methodKey.targetMethod) && Objects.equals(this.annotationClass, methodKey.annotationClass);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    static abstract class Operations {
        static final StandardExpressionContext SHARED_EL_CONTEXT;
        static final ExpressionFactory EXPRESSION_FACTORY;
        static final ConcurrentCache<MethodKey, String[]> ARGS_NAMES_CACHE;
        static final ConcurrentCache<MethodKey, CacheConfiguration> CACHE_OPERATION;
        static final Function<MethodKey, String[]> ARGS_NAMES_FUNCTION;
        static final Function<MethodKey, CacheConfiguration> CACHE_OPERATION_FUNCTION;

        Operations() {
        }

        public static CacheConfiguration prepareAnnotation(MethodKey methodKey) {
            return CACHE_OPERATION.get(methodKey, CACHE_OPERATION_FUNCTION);
        }

        static Object createKey(String key, CacheExpressionContext ctx, MethodInvocation invocation) {
            return key.isEmpty() ? new DefaultCacheKey(invocation.getArguments()) : EXPRESSION_FACTORY.createValueExpression(ctx, key, Object.class).getValue(ctx);
        }

        static boolean isConditionPassing(String condition, CacheExpressionContext context) {
            return StringUtils.isEmpty(condition) || (Boolean)EXPRESSION_FACTORY.createValueExpression(context, condition, Boolean.class).getValue(context) != false;
        }

        static boolean allowPutCache(String unless, Object result, CacheExpressionContext context) {
            if (StringUtils.isNotEmpty(unless)) {
                context.putBean("result", result);
                return (Boolean)EXPRESSION_FACTORY.createValueExpression(context, unless, Boolean.class).getValue(context) == false;
            }
            return true;
        }

        static void prepareParameterNames(MethodKey methodKey, Object[] arguments, Map<String, Object> beans) {
            String[] names = ARGS_NAMES_CACHE.get(methodKey, ARGS_NAMES_FUNCTION);
            for (int i = 0; i < names.length; ++i) {
                beans.put(names[i], arguments[i]);
            }
        }

        static CacheExpressionContext prepareELContext(MethodKey methodKey, MethodInvocation invocation) {
            HashMap<String, Object> beans = new HashMap<String, Object>();
            Operations.prepareParameterNames(methodKey, invocation.getArguments(), beans);
            beans.put("root", invocation);
            return new CacheExpressionContext(SHARED_EL_CONTEXT, beans);
        }

        static {
            EXPRESSION_FACTORY = ExpressionFactory.getSharedInstance();
            ARGS_NAMES_CACHE = new ConcurrentCache(512);
            CACHE_OPERATION = new ConcurrentCache(512);
            ARGS_NAMES_FUNCTION = target -> ClassUtils.getMethodArgsNames(((MethodKey)target).targetMethod);
            CACHE_OPERATION_FUNCTION = target -> {
                Method method = ((MethodKey)target).targetMethod;
                Class annClass = ((MethodKey)target).annotationClass;
                AnnotationAttributes attributes = ClassUtils.getAnnotationAttributes(annClass, method);
                Class<?> declaringClass = method.getDeclaringClass();
                if (attributes == null && (attributes = ClassUtils.getAnnotationAttributes(annClass, declaringClass)) == null) {
                    throw new IllegalStateException("Unexpected exception has occurred, may be it's a bug");
                }
                CacheConfiguration configuration = ClassUtils.injectAttributes(attributes, annClass, new CacheConfiguration(annClass));
                CacheConfig cacheConfig = ClassUtils.getAnnotation(CacheConfig.class, declaringClass);
                if (cacheConfig != null) {
                    configuration.mergeCacheConfigAttributes(cacheConfig);
                }
                return configuration;
            };
            ApplicationContext lastStartupContext = ContextUtils.getLastStartupContext();
            SHARED_EL_CONTEXT = lastStartupContext != null ? lastStartupContext.getEnvironment().getExpressionProcessor().getManager().getContext() : new StandardExpressionContext(EXPRESSION_FACTORY);
        }
    }
}

