/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.interceptor;

import cn.taketoday.cache.Cache;
import cn.taketoday.cache.CacheExpressionContext;
import cn.taketoday.cache.CacheManager;
import cn.taketoday.cache.CacheValueRetrievalException;
import cn.taketoday.cache.annotation.CacheConfiguration;
import cn.taketoday.cache.annotation.Cacheable;
import cn.taketoday.cache.interceptor.AbstractCacheInterceptor;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public class CacheableInterceptor
extends AbstractCacheInterceptor {
    public CacheableInterceptor() {
        this.setOrder(0x7FFFFFFE);
    }

    public CacheableInterceptor(CacheManager cacheManager) {
        this();
        this.setCacheManager(cacheManager);
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        AbstractCacheInterceptor.MethodKey methodKey = new AbstractCacheInterceptor.MethodKey(method, Cacheable.class);
        CacheConfiguration cacheable = AbstractCacheInterceptor.Operations.prepareAnnotation(methodKey);
        CacheExpressionContext context = AbstractCacheInterceptor.Operations.prepareELContext(methodKey, invocation);
        if (AbstractCacheInterceptor.Operations.isConditionPassing(cacheable.condition(), context)) {
            Cache cache = this.obtainCache(method, cacheable);
            Object key = AbstractCacheInterceptor.Operations.createKey(cacheable.key(), context, invocation);
            if (cacheable.sync()) {
                try {
                    return cache.get(key, invocation::proceed);
                }
                catch (CacheValueRetrievalException e) {
                    throw e.getCause();
                }
            }
            Object value = this.get(cache, key);
            if (value == null) {
                value = invocation.proceed();
                if (AbstractCacheInterceptor.Operations.allowPutCache(cacheable.unless(), value, context)) {
                    this.put(cache, key, value);
                }
            }
            return value;
        }
        return invocation.proceed();
    }
}

