/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context;

import cn.taketoday.context.utils.Assert;
import java.util.Map;
import java.util.function.Function;

public interface AttributeAccessor {
    public void setAttribute(String var1, Object var2);

    public Object getAttribute(String var1);

    public Object removeAttribute(String var1);

    public boolean hasAttribute(String var1);

    public String[] attributeNames();

    public Map<String, Object> getAttributes();

    default public <T> T computeAttribute(String name, Function<String, T> computeFunction) {
        Assert.notNull((Object)name, "Name must not be null");
        Assert.notNull(computeFunction, "Compute function must not be null");
        Object value = this.getAttribute(name);
        if (value == null) {
            value = computeFunction.apply(name);
            if (value == null) {
                throw new IllegalStateException("Compute function must not return null for attribute named '" + name + '\'');
            }
            this.setAttribute(name, value);
        }
        return (T)value;
    }

    public void copyAttributesFrom(AttributeAccessor var1);
}

