/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context;

import cn.taketoday.context.AttributeAccessor;
import cn.taketoday.context.Constant;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public abstract class AttributeAccessorSupport
implements AttributeAccessor {
    protected HashMap<String, Object> attributes;

    @Override
    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.getAttributes().put(name, value);
        } else {
            this.removeAttribute(name);
        }
    }

    @Override
    public Object getAttribute(String name) {
        HashMap<String, Object> attributes = this.attributes;
        if (attributes == null) {
            return null;
        }
        return attributes.get(name);
    }

    @Override
    public <T> T computeAttribute(String name, Function<String, T> computeFunction) {
        Assert.notNull((Object)name, "Name must not be null");
        Assert.notNull(computeFunction, "Compute function must not be null");
        Object value = this.getAttributes().computeIfAbsent(name, computeFunction);
        Assert.state(value != null, () -> String.format("Compute function must not return null for attribute named '%s'", name));
        return (T)value;
    }

    @Override
    public Object removeAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.remove(name);
        }
        return null;
    }

    @Override
    public boolean hasAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.containsKey(name);
        }
        return false;
    }

    @Override
    public String[] attributeNames() {
        if (this.attributes != null) {
            return StringUtils.toStringArray(this.attributes.keySet());
        }
        return Constant.EMPTY_STRING_ARRAY;
    }

    @Override
    public void copyAttributesFrom(AttributeAccessor source) {
        Assert.notNull((Object)source, "Source must not be null");
        Map<String, Object> attributes = source.getAttributes();
        if (!CollectionUtils.isEmpty(attributes)) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                this.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public void clear() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
    }

    public boolean equals(Object other) {
        return this == other || other instanceof AttributeAccessorSupport && Objects.equals(this.attributes, ((AttributeAccessorSupport)other).attributes);
    }

    @Override
    public Map<String, Object> getAttributes() {
        HashMap<String, Object> attributes = this.attributes;
        if (attributes == null) {
            this.attributes = this.createAttributes();
            return this.attributes;
        }
        return attributes;
    }

    protected HashMap<String, Object> createAttributes() {
        return new HashMap<String, Object>();
    }
}

