/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context;

import cn.taketoday.context.AbstractApplicationContext;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.context.env.ConfigurableEnvironment;
import cn.taketoday.context.env.StandardEnvironment;
import cn.taketoday.context.factory.AbstractBeanFactory;
import cn.taketoday.context.factory.StandardBeanFactory;
import java.util.Collection;

public class StandardApplicationContext
extends AbstractApplicationContext
implements ConfigurableApplicationContext {
    private StandardBeanFactory beanFactory;

    public StandardApplicationContext() {
        this(new StandardEnvironment());
    }

    public StandardApplicationContext(ConfigurableEnvironment env) {
        super(env);
    }

    public StandardApplicationContext(String propertiesLocation) {
        this();
        this.setPropertiesLocation(propertiesLocation);
    }

    public StandardApplicationContext(Collection<Class<?>> classes) {
        this("");
        this.load(classes);
    }

    public StandardApplicationContext(StandardBeanFactory beanFactory) {
        this();
        this.beanFactory = beanFactory;
    }

    public StandardApplicationContext(String propertiesLocation, String ... locations) {
        this(propertiesLocation);
        this.load(locations);
    }

    @Override
    public StandardBeanFactory getBeanFactory() {
        StandardBeanFactory beanFactory = this.beanFactory;
        if (beanFactory == null) {
            this.beanFactory = this.createBeanFactory();
            return this.beanFactory;
        }
        return beanFactory;
    }

    protected StandardBeanFactory createBeanFactory() {
        return new StandardBeanFactory(this);
    }

    @Override
    protected void loadBeanDefinitions(AbstractBeanFactory beanFactory, Collection<Class<?>> candidates) {
        super.loadBeanDefinitions(beanFactory, candidates);
        candidates.addAll(this.beanFactory.loadMetaInfoBeans());
        this.beanFactory.loadConfigurationBeans();
        this.beanFactory.loadMissingBean(candidates);
    }
}

