/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation.condition;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.Condition;
import cn.taketoday.context.annotation.condition.ConditionalOnProperty;
import cn.taketoday.context.env.Environment;
import cn.taketoday.context.utils.StringUtils;
import java.lang.reflect.AnnotatedElement;

class OnPropertyCondition
implements Condition {
    OnPropertyCondition() {
    }

    @Override
    public boolean matches(ApplicationContext context, AnnotatedElement annotated) {
        ConditionalOnProperty conditionalOnProperty = annotated.getAnnotation(ConditionalOnProperty.class);
        String prefix = conditionalOnProperty.prefix();
        Environment environment = context.getEnvironment();
        if (StringUtils.isEmpty(prefix)) {
            for (String key : conditionalOnProperty.value()) {
                if (environment.getProperty(key) != null) continue;
                return false;
            }
        } else {
            for (String key : conditionalOnProperty.value()) {
                if (environment.getProperty(prefix + key) != null) continue;
                return false;
            }
        }
        return true;
    }
}

