/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.beans;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.AbstractClassGenerator;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.KeyFactory;
import java.beans.PropertyDescriptor;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BeanGenerator
extends AbstractClassGenerator<Object> {
    private static final BeanGeneratorKey KEY_FACTORY = KeyFactory.create(BeanGeneratorKey.class);
    private boolean classOnly;
    private Class<?> superclass;
    private Map<String, Type> props = new HashMap<String, Type>();

    public BeanGenerator() {
        super(BeanGenerator.class);
    }

    public void setSuperclass(Class<?> superclass) {
        if (superclass != null && superclass.equals(Object.class)) {
            superclass = null;
        }
        this.superclass = superclass;
    }

    public void addProperty(String name, Class<?> type) {
        if (this.props.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate property name \"" + name + "\"");
        }
        this.props.put(name, Type.getType(type));
    }

    @Override
    protected ClassLoader getDefaultClassLoader() {
        if (this.superclass != null) {
            return this.superclass.getClassLoader();
        }
        return null;
    }

    @Override
    protected ProtectionDomain getProtectionDomain() {
        return CglibReflectUtils.getProtectionDomain(this.superclass);
    }

    public Object create() {
        this.classOnly = false;
        return this.createHelper();
    }

    public Object createClass() {
        this.classOnly = true;
        return this.createHelper();
    }

    private Object createHelper() {
        if (this.superclass != null) {
            this.setNamePrefix(this.superclass.getName());
        }
        String superName = this.superclass != null ? this.superclass.getName() : "java.lang.Object";
        Object key = KEY_FACTORY.newInstance(superName, this.props);
        return super.create(key);
    }

    @Override
    public void generateClass(ClassVisitor v) {
        Map<String, Type> props = this.props;
        int size = props.size();
        Type[] types = new Type[size];
        int i = 0;
        for (Map.Entry<String, Type> entry : props.entrySet()) {
            types[i++] = entry.getValue();
        }
        ClassEmitter ce = new ClassEmitter(v);
        ce.beginClass(52, 1, this.getClassName(), this.superclass != null ? Type.getType(this.superclass) : Constant.TYPE_OBJECT, null, new Type[0]);
        EmitUtils.nullConstructor(ce);
        Set<String> keySet = props.keySet();
        EmitUtils.addProperties(ce, keySet.toArray(new String[keySet.size()]), types);
        ce.endClass();
    }

    @Override
    protected Object firstInstance(Class<Object> type) {
        if (this.classOnly) {
            return type;
        }
        return CglibReflectUtils.newInstance(type);
    }

    @Override
    protected Object nextInstance(Object instance) {
        Class<?> protoclass;
        Class<?> clazz = protoclass = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        if (this.classOnly) {
            return protoclass;
        }
        return CglibReflectUtils.newInstance(protoclass);
    }

    public static void addProperties(BeanGenerator gen, Map<String, Class<?>> props) {
        props.forEach(gen::addProperty);
    }

    public static void addProperties(BeanGenerator gen, Class<?> type) {
        BeanGenerator.addProperties(gen, CglibReflectUtils.getBeanProperties(type));
    }

    public static void addProperties(BeanGenerator gen, PropertyDescriptor[] descriptors) {
        for (PropertyDescriptor descriptor : descriptors) {
            gen.addProperty(descriptor.getName(), descriptor.getPropertyType());
        }
    }

    static interface BeanGeneratorKey {
        public Object newInstance(String var1, Map<String, Type> var2);
    }
}

