/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.beans;

import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.cglib.beans.BeanMapEmitter;
import cn.taketoday.context.cglib.core.AbstractClassGenerator;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.KeyFactory;
import cn.taketoday.context.utils.Assert;
import java.security.ProtectionDomain;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class BeanMap
extends AbstractMap
implements Map {
    public static final int REQUIRE_GETTER = 1;
    public static final int REQUIRE_SETTER = 2;
    protected Object bean;

    public static BeanMap create(Object bean) {
        Generator gen = new Generator();
        gen.setBean(bean);
        return gen.create();
    }

    public abstract BeanMap newInstance(Object var1);

    public abstract Class getPropertyType(String var1);

    protected BeanMap() {
    }

    protected BeanMap(Object bean) {
        this.setBean(bean);
    }

    public Object get(Object key) {
        return this.get(this.bean, key);
    }

    public Object put(Object key, Object value) {
        return this.put(this.bean, key, value);
    }

    public abstract Object get(Object var1, Object var2);

    public abstract Object put(Object var1, Object var2, Object var3);

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object key : this.keySet()) {
            Object v = this.get(key);
            if (!Objects.equals(value, v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        for (Object key : t.keySet()) {
            this.put(key, t.get(key));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o != this) {
            if (!(o instanceof Map)) {
                return false;
            }
            Map other = (Map)o;
            if (this.size() != other.size()) {
                return false;
            }
            for (Object key : this.keySet()) {
                if (Objects.equals(this.get(key), other.get(key))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int code = 0;
        for (Object key : this.keySet()) {
            code += Objects.hashCode(key) ^ Objects.hashCode(this.get(key));
        }
        return code;
    }

    public Set entrySet() {
        HashMap copy = new HashMap();
        for (Object key : this.keySet()) {
            copy.put(key, this.get(key));
        }
        return Collections.unmodifiableSet(copy.entrySet());
    }

    public Collection values() {
        Set keys = this.keySet();
        ArrayList<Object> values = new ArrayList<Object>(keys.size());
        for (Object key : keys) {
            values.add(this.get(key));
        }
        return Collections.unmodifiableCollection(values);
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final BeanMapKey KEY_FACTORY = KeyFactory.create(BeanMapKey.class, KeyFactory.CLASS_BY_NAME);
        private Object bean;
        private Class beanClass;
        private int require;

        public Generator() {
            super(BeanMap.class);
        }

        public void setBean(Object bean) {
            this.bean = bean;
            if (bean != null) {
                this.beanClass = bean.getClass();
            }
        }

        public void setBeanClass(Class beanClass) {
            this.beanClass = beanClass;
        }

        public void setRequire(int require) {
            this.require = require;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.beanClass.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return CglibReflectUtils.getProtectionDomain(this.beanClass);
        }

        public BeanMap create() {
            Assert.notNull((Object)this.beanClass, "Class of bean unknown");
            this.setNamePrefix(this.beanClass.getName());
            return (BeanMap)super.create(KEY_FACTORY.newInstance(this.beanClass, this.require));
        }

        @Override
        public void generateClass(ClassVisitor v) throws Exception {
            new BeanMapEmitter(v, this.getClassName(), this.beanClass, this.require);
        }

        protected Object firstInstance(Class type) {
            return ((BeanMap)CglibReflectUtils.newInstance(type)).newInstance(this.bean);
        }

        @Override
        protected Object nextInstance(Object instance) {
            return ((BeanMap)instance).newInstance(this.bean);
        }

        static interface BeanMapKey {
            public Object newInstance(Class var1, int var2);
        }
    }
}

