/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.core;

import cn.taketoday.context.cglib.core.ClassGenerator;
import cn.taketoday.context.cglib.core.CodeGenerationException;
import cn.taketoday.context.cglib.core.DefaultGeneratorStrategy;
import cn.taketoday.context.cglib.core.DefaultNamingPolicy;
import cn.taketoday.context.cglib.core.GeneratorStrategy;
import cn.taketoday.context.cglib.core.NamingPolicy;
import cn.taketoday.context.cglib.core.internal.LoadingCache;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class AbstractClassGenerator<T>
implements ClassGenerator {
    private static volatile Map<ClassLoader, ClassLoaderData> CACHE = new WeakHashMap<ClassLoader, ClassLoaderData>();
    private static final ThreadLocal<AbstractClassGenerator> CURRENT = new ThreadLocal();
    private GeneratorStrategy strategy = DefaultGeneratorStrategy.INSTANCE;
    private NamingPolicy namingPolicy = DefaultNamingPolicy.INSTANCE;
    private final String source;
    private ClassLoader classLoader;
    private String namePrefix;
    private Object key;
    private boolean useCache = true;
    private String className;
    private boolean attemptLoad;

    protected T wrapCachedClass(Class klass) {
        return (T)new WeakReference<Class>(klass);
    }

    protected Object unwrapCachedValue(T cached) {
        return ((WeakReference)cached).get();
    }

    protected AbstractClassGenerator(String source) {
        this.source = source;
    }

    protected AbstractClassGenerator(Class<?> source) {
        this(source.getSimpleName());
    }

    protected AbstractClassGenerator setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
        return this;
    }

    protected final String getClassName() {
        return this.className;
    }

    private AbstractClassGenerator setClassName(String className) {
        this.className = className;
        return this;
    }

    private String generateClassName(Predicate nameTestPredicate) {
        return this.namingPolicy.getClassName(this.namePrefix, this.source, this.key, nameTestPredicate);
    }

    public AbstractClassGenerator setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public AbstractClassGenerator setNamingPolicy(NamingPolicy namingPolicy) {
        this.namingPolicy = namingPolicy == null ? DefaultNamingPolicy.INSTANCE : namingPolicy;
        return this;
    }

    public NamingPolicy getNamingPolicy() {
        return this.namingPolicy;
    }

    public AbstractClassGenerator setUseCache(boolean useCache) {
        this.useCache = useCache;
        return this;
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public AbstractClassGenerator setAttemptLoad(boolean attemptLoad) {
        this.attemptLoad = attemptLoad;
        return this;
    }

    public boolean isAttemptLoad() {
        return this.attemptLoad;
    }

    public AbstractClassGenerator setStrategy(GeneratorStrategy strategy) {
        this.strategy = strategy == null ? DefaultGeneratorStrategy.INSTANCE : strategy;
        return this;
    }

    public GeneratorStrategy getStrategy() {
        return this.strategy;
    }

    public static AbstractClassGenerator getCurrent() {
        return CURRENT.get();
    }

    public ClassLoader getClassLoader() {
        ClassLoader t = this.classLoader;
        if (t == null) {
            t = this.getDefaultClassLoader();
        }
        if (t == null) {
            return ClassUtils.getClassLoader();
        }
        return t;
    }

    protected abstract ClassLoader getDefaultClassLoader();

    protected ProtectionDomain getProtectionDomain() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object create(Object key) {
        this.key = key;
        try {
            ClassLoader loader = this.getClassLoader();
            ClassLoaderData data = CACHE.get(loader);
            Object obj = data.get(this, this.getUseCache());
            if (data != null) return obj instanceof Class ? this.firstInstance((Class)obj) : this.nextInstance(obj);
            Class<AbstractClassGenerator> clazz = AbstractClassGenerator.class;
            synchronized (AbstractClassGenerator.class) {
                data = CACHE.get(loader);
                obj = data.get(this, this.getUseCache());
                if (data != null) return obj instanceof Class ? this.firstInstance((Class)obj) : this.nextInstance(obj);
                WeakHashMap<ClassLoader, ClassLoaderData> newCache = new WeakHashMap<ClassLoader, ClassLoaderData>(CACHE);
                data = new ClassLoaderData(loader);
                newCache.put(loader, data);
                CACHE = newCache;
                // ** MonitorExit[var4_6] (shouldn't be in output)
                return obj instanceof Class ? this.firstInstance((Class)obj) : this.nextInstance(obj);
            }
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    /*
     * Exception decompiling
     */
    protected Class generate(ClassLoaderData data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract Object firstInstance(Class<T> var1) throws Exception;

    protected abstract Object nextInstance(Object var1) throws Exception;

    protected static class ClassLoaderData {
        private final Set<String> reservedClassNames = new HashSet<String>();
        private final LoadingCache<AbstractClassGenerator, Object, Object> generatedClasses;
        private final WeakReference<ClassLoader> classLoader;
        private static final Function<AbstractClassGenerator, Object> GET_KEY = gen -> AbstractClassGenerator.access$000(gen);
        private final Predicate<Object> uniqueNamePredicate = this.reservedClassNames::contains;

        public ClassLoaderData(ClassLoader classLoader) {
            Assert.notNull((Object)classLoader, "classLoader == null is not yet supported");
            this.classLoader = new WeakReference<ClassLoader>(classLoader);
            this.generatedClasses = new LoadingCache<AbstractClassGenerator, Object, Object>(GET_KEY, gen -> gen.wrapCachedClass(gen.generate(this)));
        }

        public ClassLoader getClassLoader() {
            return (ClassLoader)this.classLoader.get();
        }

        public void reserveName(String name) {
            this.reservedClassNames.add(name);
        }

        public Predicate getUniqueNamePredicate() {
            return this.uniqueNamePredicate;
        }

        public Object get(AbstractClassGenerator gen, boolean useCache) {
            if (useCache) {
                Object cached = this.generatedClasses.get(gen);
                return gen.unwrapCachedValue(cached);
            }
            return gen.generate(this);
        }
    }
}

