/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.core;

import cn.taketoday.context.cglib.core.Transformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public abstract class CglibCollectionUtils {
    public static <K, T> Map<K, List<T>> bucket(Collection<T> c, Transformer<T, K> t) {
        HashMap<K, ArrayList<T>> buckets = new HashMap<K, ArrayList<T>>();
        for (T value : c) {
            K key = t.transform(value);
            ArrayList<T> bucket = (ArrayList<T>)buckets.get(key);
            if (bucket == null) {
                bucket = new ArrayList<T>();
                buckets.put(key, bucket);
            }
            bucket.add(value);
        }
        return buckets;
    }

    public static <T> void reverse(Map<T, T> source, Map<T, T> target) {
        for (Map.Entry<T, T> entry : source.entrySet()) {
            target.put(entry.getValue(), entry.getKey());
        }
    }

    public static Collection<Object> filter(Collection c, Predicate p) {
        c.removeIf(o -> !p.test(o));
        return c;
    }

    public static <T, R> List<R> transform(Collection<T> c, Transformer<T, R> t) {
        ArrayList<R> result = new ArrayList<R>(c.size());
        for (T obj : c) {
            result.add(t.transform(obj));
        }
        return result;
    }

    public static <T> Map<T, Integer> getIndexMap(List<T> list) {
        HashMap<T, Integer> indexes = new HashMap<T, Integer>();
        int index = 0;
        for (T obj : list) {
            indexes.put(obj, index++);
        }
        return indexes;
    }
}

