/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.core;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.Attribute;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.ClassInfo;
import cn.taketoday.context.cglib.core.CodeGenerationException;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.TypeUtils;
import cn.taketoday.context.reflect.ReflectionException;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ReflectionUtils;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public abstract class CglibReflectUtils {
    private static final HashMap<String, Class> primitives = new HashMap();
    private static final HashMap<String, String> transforms = new HashMap();
    private static final Method defineClass;
    private static final ArrayList<Method> OBJECT_METHODS;
    private static final String[] CGLIB_PACKAGES;

    public static ProtectionDomain getProtectionDomain(Class<?> source) {
        return source == null ? null : AccessController.doPrivileged(source::getProtectionDomain);
    }

    public static Type[] getExceptionTypes(Member member) {
        if (member instanceof Executable) {
            return TypeUtils.getTypes(((Executable)member).getExceptionTypes());
        }
        throw new IllegalArgumentException("Cannot get exception types of a field");
    }

    public static Signature getSignature(Member member) {
        if (member instanceof Method) {
            return new Signature(member.getName(), Type.getMethodDescriptor((Method)member));
        }
        if (member instanceof Constructor) {
            Type[] types = TypeUtils.getTypes(((Constructor)member).getParameterTypes());
            return new Signature("<init>", Type.getMethodDescriptor(Type.VOID_TYPE, types));
        }
        throw new IllegalArgumentException("Cannot get signature of a field");
    }

    public static Constructor findConstructor(String desc) {
        return CglibReflectUtils.findConstructor(desc, ClassUtils.getClassLoader());
    }

    public static Constructor findConstructor(String desc, ClassLoader loader) {
        try {
            String className = desc.substring(0, desc.indexOf(40)).trim();
            return CglibReflectUtils.getClass(className, loader).getConstructor(CglibReflectUtils.parseTypes(desc, loader));
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
    }

    public static Method findMethod(String desc) {
        return CglibReflectUtils.findMethod(desc, ClassUtils.getClassLoader());
    }

    public static Method findMethod(String desc, ClassLoader loader) {
        try {
            int lparen = desc.indexOf(40);
            int dot = desc.lastIndexOf(46, lparen);
            String className = desc.substring(0, dot).trim();
            String methodName = desc.substring(dot + 1, lparen).trim();
            return CglibReflectUtils.getClass(className, loader).getDeclaredMethod(methodName, CglibReflectUtils.parseTypes(desc, loader));
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
    }

    private static Class[] parseTypes(String desc, ClassLoader loader) throws ClassNotFoundException {
        int comma;
        int lparen = desc.indexOf(40);
        int rparen = desc.indexOf(41, lparen);
        ArrayList<String> params = new ArrayList<String>();
        int start = lparen + 1;
        while ((comma = desc.indexOf(44, start)) >= 0) {
            params.add(desc.substring(start, comma).trim());
            start = comma + 1;
        }
        if (start < rparen) {
            params.add(desc.substring(start, rparen).trim());
        }
        int i = 0;
        Class[] types = new Class[params.size()];
        for (String name : params) {
            types[i++] = CglibReflectUtils.getClass(name, loader);
        }
        return types;
    }

    private static Class getClass(String className, ClassLoader loader) throws ClassNotFoundException {
        return CglibReflectUtils.getClass(className, loader, CGLIB_PACKAGES);
    }

    private static Class getClass(String className, ClassLoader loader, String[] packages) throws ClassNotFoundException {
        String save = className;
        int dimensions = 0;
        int index = 0;
        while ((index = className.indexOf("[]", index) + 1) > 0) {
            ++dimensions;
        }
        StringBuilder brackets = new StringBuilder(className.length() - dimensions);
        for (int i = 0; i < dimensions; ++i) {
            brackets.append('[');
        }
        className = className.substring(0, className.length() - 2 * dimensions);
        String prefix = dimensions > 0 ? brackets + "L" : "";
        String suffix = dimensions > 0 ? ";" : "";
        try {
            return Class.forName(prefix + className + suffix, false, loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            for (int i = 0; i < packages.length; ++i) {
                try {
                    return Class.forName(prefix + packages[i] + '.' + className + suffix, false, loader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    continue;
                }
            }
            if (dimensions == 0) {
                Class c = primitives.get(className);
                if (c != null) {
                    return c;
                }
            } else {
                String transform = transforms.get(className);
                if (transform != null) {
                    try {
                        return Class.forName(brackets.append(transform).toString(), false, loader);
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        // empty catch block
                    }
                }
            }
            throw new ClassNotFoundException(save);
        }
    }

    public static <T> T newInstance(Class<T> type) {
        return CglibReflectUtils.newInstance(type, Constant.EMPTY_CLASS_ARRAY, null);
    }

    public static <T> T newInstance(Class<T> type, Class[] parameterTypes, Object[] args) {
        return CglibReflectUtils.newInstance(CglibReflectUtils.getConstructor(type, parameterTypes), args);
    }

    public static <T> T newInstance(Constructor<T> cstruct, Object[] args) {
        try {
            return cstruct.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CodeGenerationException(e);
        }
        catch (InvocationTargetException e) {
            throw new CodeGenerationException(e.getTargetException());
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> type, Class[] parameterTypes) {
        try {
            return ReflectionUtils.accessibleConstructor(type, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
    }

    public static String[] getNames(Class[] classes) {
        if (classes == null) {
            return null;
        }
        int i = 0;
        String[] names = new String[classes.length];
        for (Class clazz : classes) {
            names[i++] = clazz.getName();
        }
        return names;
    }

    public static Class[] getClasses(Object[] objects) {
        int i = 0;
        Class[] classes = new Class[objects.length];
        for (Object obj : objects) {
            classes[i++] = obj.getClass();
        }
        return classes;
    }

    public static Method findNewInstance(Class<?> iface) {
        Method m = CglibReflectUtils.findInterfaceMethod(iface);
        if (m.getName().equals("newInstance")) {
            return m;
        }
        throw new IllegalArgumentException(iface + " missing newInstance method");
    }

    public static Method[] getPropertyMethods(PropertyDescriptor[] properties, boolean read, boolean write) {
        HashSet<Method> methods = new HashSet<Method>();
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor pd = properties[i];
            if (read) {
                methods.add(pd.getReadMethod());
            }
            if (!write) continue;
            methods.add(pd.getWriteMethod());
        }
        methods.remove(null);
        return methods.toArray(new Method[methods.size()]);
    }

    public static PropertyDescriptor[] getBeanProperties(Class<?> type) {
        return CglibReflectUtils.getPropertiesHelper(type, true, true);
    }

    public static PropertyDescriptor[] getBeanGetters(Class<?> type) {
        return CglibReflectUtils.getPropertiesHelper(type, true, false);
    }

    public static PropertyDescriptor[] getBeanSetters(Class<?> type) {
        return CglibReflectUtils.getPropertiesHelper(type, false, true);
    }

    private static PropertyDescriptor[] getPropertiesHelper(Class<?> type, boolean read, boolean write) {
        try {
            PropertyDescriptor[] all = Introspector.getBeanInfo(type, Object.class).getPropertyDescriptors();
            if (read && write) {
                return all;
            }
            ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(all.length);
            for (PropertyDescriptor pd : all) {
                if ((!read || pd.getReadMethod() == null) && (!write || pd.getWriteMethod() == null)) continue;
                properties.add(pd);
            }
            return properties.toArray(new PropertyDescriptor[properties.size()]);
        }
        catch (IntrospectionException e) {
            throw new CodeGenerationException(e);
        }
    }

    public static List<Method> addAllMethods(Class<?> type, List<Method> list) {
        if (type == Object.class) {
            list.addAll(OBJECT_METHODS);
        } else {
            Collections.addAll(list, type.getDeclaredMethods());
        }
        Class<?> superclass = type.getSuperclass();
        if (superclass != null) {
            CglibReflectUtils.addAllMethods(superclass, list);
        }
        for (Class<?> interface_ : type.getInterfaces()) {
            CglibReflectUtils.addAllMethods(interface_, list);
        }
        return list;
    }

    public static List<Class<?>> addAllInterfaces(Class<?> type, List<Class<?>> list) {
        Class<?> superclass = type.getSuperclass();
        if (superclass != null) {
            Collections.addAll(list, type.getInterfaces());
            CglibReflectUtils.addAllInterfaces(superclass, list);
        }
        return list;
    }

    public static Method findInterfaceMethod(Class iface) {
        if (iface.isInterface()) {
            Method[] methods = iface.getDeclaredMethods();
            if (methods.length != 1) {
                throw new IllegalArgumentException("expecting exactly 1 method in " + iface);
            }
            return methods[0];
        }
        throw new IllegalArgumentException(iface + " is not an interface");
    }

    public static <T> Class<T> defineClass(String className, byte[] bytes, ClassLoader loader, ProtectionDomain protection) throws Exception {
        try {
            return (Class)defineClass.invoke((Object)loader, className, bytes, 0, bytes.length, protection);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectionException("defineClass failed", e);
        }
    }

    public static int findPackageProtected(Class[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (Modifier.isPublic(classes[i].getModifiers())) continue;
            return i;
        }
        return 0;
    }

    public static MethodInfo getMethodInfo(final Member member, final int modifiers) {
        final Signature sig = CglibReflectUtils.getSignature(member);
        return new MethodInfo(){
            private ClassInfo ci;

            @Override
            public ClassInfo getClassInfo() {
                if (this.ci == null) {
                    this.ci = CglibReflectUtils.getClassInfo(member.getDeclaringClass());
                }
                return this.ci;
            }

            @Override
            public int getModifiers() {
                return modifiers;
            }

            @Override
            public Signature getSignature() {
                return sig;
            }

            @Override
            public Type[] getExceptionTypes() {
                return CglibReflectUtils.getExceptionTypes(member);
            }

            public Attribute getAttribute() {
                return null;
            }
        };
    }

    public static MethodInfo getMethodInfo(Member member) {
        return CglibReflectUtils.getMethodInfo(member, member.getModifiers());
    }

    public static ClassInfo getClassInfo(final Class clazz) {
        final Type type = Type.getType(clazz);
        final Type sc = clazz.getSuperclass() == null ? null : Type.getType(clazz.getSuperclass());
        return new ClassInfo(){

            @Override
            public Type getType() {
                return type;
            }

            @Override
            public Type getSuperType() {
                return sc;
            }

            @Override
            public Type[] getInterfaces() {
                return TypeUtils.getTypes(clazz.getInterfaces());
            }

            @Override
            public int getModifiers() {
                return clazz.getModifiers();
            }
        };
    }

    public static Method[] findMethods(String[] namesAndDescriptors, Method[] methods) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (Method method : methods) {
            map.put(method.getName().concat(Type.getMethodDescriptor(method)), method);
        }
        Method[] result = new Method[namesAndDescriptors.length / 2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Method)map.get(namesAndDescriptors[i * 2] + namesAndDescriptors[i * 2 + 1]);
        }
        return result;
    }

    static {
        CGLIB_PACKAGES = new String[]{"java.lang"};
        Class<ClassLoader> loader = ClassLoader.class;
        try {
            defineClass = loader.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            ReflectionUtils.makeAccessible(defineClass);
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
        Method[] declaredMethods = Object.class.getDeclaredMethods();
        OBJECT_METHODS = new ArrayList(declaredMethods.length);
        for (Method method : declaredMethods) {
            if ("finalize".equals(method.getName()) || (method.getModifiers() & 0x18) > 0) continue;
            OBJECT_METHODS.add(method);
        }
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        transforms.put("byte", "B");
        transforms.put("char", "C");
        transforms.put("double", "D");
        transforms.put("float", "F");
        transforms.put("int", "I");
        transforms.put("long", "J");
        transforms.put("short", "S");
        transforms.put("boolean", "Z");
    }
}

