/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.core;

import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.TypeUtils;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;

public class VisibilityPredicate
implements Predicate<Executable> {
    private String pkg;
    private boolean protectedOk;
    private boolean samePackageOk;

    public VisibilityPredicate(Class<?> source, boolean protectedOk) {
        this.protectedOk = protectedOk;
        this.samePackageOk = source.getClassLoader() != null;
        this.pkg = TypeUtils.getPackageName(Type.getType(source));
    }

    @Override
    public boolean test(Executable member) {
        int mod = member.getModifiers();
        if (Modifier.isPrivate(mod)) {
            return false;
        }
        if (Modifier.isPublic(mod) || Modifier.isProtected(mod) && this.protectedOk) {
            return true;
        }
        return this.samePackageOk && this.pkg.equals(TypeUtils.getPackageName(Type.getType(member.getDeclaringClass())));
    }
}

