/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.proxy;

import cn.taketoday.context.Constant;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.proxy.Callback;
import cn.taketoday.context.cglib.proxy.CallbackFilter;
import cn.taketoday.context.cglib.proxy.Enhancer;
import cn.taketoday.context.utils.ObjectUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class CallbackHelper
implements CallbackFilter {
    private ArrayList<Object> callbacks = new ArrayList();
    private Map<Method, Integer> methodMap = new HashMap<Method, Integer>();

    public CallbackHelper(Class<?> superclass, Class<?>[] interfaces) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Enhancer.getMethods(superclass, interfaces, methods);
        HashMap<Object, Integer> indexes = new HashMap<Object, Integer>();
        ArrayList<Object> callbacks = this.callbacks;
        int size = methods.size();
        for (int i = 0; i < size; ++i) {
            Method method = (Method)methods.get(i);
            Object callback = this.getCallback(method);
            if (callback == null) {
                throw new IllegalStateException("getCallback cannot return null");
            }
            boolean isCallback = callback instanceof Callback;
            if (!isCallback && !(callback instanceof Class)) {
                throw new IllegalStateException("getCallback must return a Callback or a Class");
            }
            if (i > 0 && callbacks.get(i - 1) instanceof Callback ^ isCallback) {
                throw new IllegalStateException("getCallback must return a Callback or a Class consistently for every Method");
            }
            Integer index = (Integer)indexes.get(callback);
            if (index == null) {
                index = callbacks.size();
                indexes.put(callback, index);
            }
            this.methodMap.put(method, index);
            callbacks.add(callback);
        }
    }

    protected abstract Object getCallback(Method var1);

    public Callback[] getCallbacks() {
        ArrayList<Object> callbacks = this.callbacks;
        if (ObjectUtils.isEmpty(callbacks)) {
            return new Callback[0];
        }
        if (callbacks.get(0) instanceof Callback) {
            return callbacks.toArray(new Callback[callbacks.size()]);
        }
        throw new IllegalStateException("getCallback returned classes, not callbacks; call getCallbackTypes instead");
    }

    public Class<?>[] getCallbackTypes() {
        ArrayList<Object> callbacks = this.callbacks;
        if (ObjectUtils.isEmpty(callbacks)) {
            return Constant.EMPTY_CLASS_ARRAY;
        }
        if (callbacks.get(0) instanceof Callback) {
            return CglibReflectUtils.getClasses(this.getCallbacks());
        }
        return callbacks.toArray(new Class[callbacks.size()]);
    }

    @Override
    public int accept(Method method) {
        return this.methodMap.get(method);
    }

    public int hashCode() {
        return this.methodMap.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof CallbackHelper && this.methodMap.equals(((CallbackHelper)o).methodMap);
    }
}

