/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.proxy;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.ClassReader;
import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Label;
import cn.taketoday.context.asm.MethodVisitor;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.AbstractClassGenerator;
import cn.taketoday.context.cglib.core.CglibCollectionUtils;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.CodeGenerationException;
import cn.taketoday.context.cglib.core.DuplicatesPredicate;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.GeneratorStrategy;
import cn.taketoday.context.cglib.core.KeyFactory;
import cn.taketoday.context.cglib.core.Local;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.MethodInfoTransformer;
import cn.taketoday.context.cglib.core.MethodWrapper;
import cn.taketoday.context.cglib.core.NamingPolicy;
import cn.taketoday.context.cglib.core.ObjectSwitchCallback;
import cn.taketoday.context.cglib.core.ProcessSwitchCallback;
import cn.taketoday.context.cglib.core.RejectModifierPredicate;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.TypeUtils;
import cn.taketoday.context.cglib.core.VisibilityPredicate;
import cn.taketoday.context.cglib.core.WeakCacheKey;
import cn.taketoday.context.cglib.proxy.Callback;
import cn.taketoday.context.cglib.proxy.CallbackFilter;
import cn.taketoday.context.cglib.proxy.CallbackGenerator;
import cn.taketoday.context.cglib.proxy.CallbackInfo;
import cn.taketoday.context.cglib.proxy.Factory;
import cn.taketoday.context.utils.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Enhancer
extends AbstractClassGenerator<Object> {
    private static final CallbackFilter ALL_ZERO = m -> 0;
    private static final EnhancerKey KEY_FACTORY = KeyFactory.create(EnhancerKey.class, KeyFactory.HASH_ASM_TYPE, null);
    private static final String BOUND_FIELD = "TODAY$BOUND";
    private static final String CONSTRUCTED_FIELD = "TODAY$CONSTRUCTED";
    private static final String FACTORY_DATA_FIELD = "TODAY$FACTORY_DATA";
    private static final String THREAD_CALLBACKS_FIELD = "TODAY$THREAD_CALLBACKS";
    private static final String STATIC_CALLBACKS_FIELD = "TODAY$STATIC_CALLBACKS";
    private static final String SET_THREAD_CALLBACKS_NAME = "TODAY$SET_THREAD_CALLBACKS";
    private static final String SET_STATIC_CALLBACKS_NAME = "TODAY$SET_STATIC_CALLBACKS";
    private static final String CALLBACK_FILTER_FIELD = "TODAY$CALLBACK_FILTER";
    private static final Type OBJECT_TYPE = Constant.TYPE_OBJECT;
    private static final Type FACTORY = TypeUtils.parseType(Factory.class);
    private static final Type ILLEGAL_STATE_EXCEPTION = TypeUtils.parseType("IllegalStateException");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Type THREAD_LOCAL = TypeUtils.parseType("ThreadLocal");
    private static final Type CALLBACK = TypeUtils.parseType(Callback.class);
    private static final Type CALLBACK_ARRAY = Type.getType(Callback[].class);
    private static final Signature CSTRUCT_NULL = TypeUtils.parseConstructor("");
    private static final Signature SET_THREAD_CALLBACKS = new Signature("TODAY$SET_THREAD_CALLBACKS", Type.VOID_TYPE, Type.array(CALLBACK_ARRAY));
    private static final Signature SET_STATIC_CALLBACKS = new Signature("TODAY$SET_STATIC_CALLBACKS", Type.VOID_TYPE, Type.array(CALLBACK_ARRAY));
    private static final Signature NEW_INSTANCE = new Signature("newInstance", Constant.TYPE_OBJECT, Type.array(CALLBACK_ARRAY));
    private static final Signature MULTIARG_NEW_INSTANCE = new Signature("newInstance", Constant.TYPE_OBJECT, Type.array(Constant.TYPE_CLASS_ARRAY, Constant.TYPE_OBJECT_ARRAY, CALLBACK_ARRAY));
    private static final Signature SINGLE_NEW_INSTANCE = new Signature("newInstance", Constant.TYPE_OBJECT, Type.array(CALLBACK));
    private static final Signature SET_CALLBACK = new Signature("setCallback", Type.VOID_TYPE, Type.array(Type.INT_TYPE, CALLBACK));
    private static final Signature GET_CALLBACK = new Signature("getCallback", CALLBACK, Type.array(Type.INT_TYPE));
    private static final Signature SET_CALLBACKS = new Signature("setCallbacks", Type.VOID_TYPE, Type.array(CALLBACK_ARRAY));
    private static final Signature GET_CALLBACKS = new Signature("getCallbacks", CALLBACK_ARRAY, new Type[0]);
    private static final Signature THREAD_LOCAL_GET = TypeUtils.parseSignature("Object get()");
    private static final Signature THREAD_LOCAL_SET = TypeUtils.parseSignature("void set(Object)");
    private static final Signature BIND_CALLBACKS = TypeUtils.parseSignature("void TODAY$BIND_CALLBACKS(Object)");
    private EnhancerFactoryData currentData;
    private Object currentKey;
    private Class<?>[] interfaces;
    private CallbackFilter filter;
    private Callback[] callbacks;
    private Type[] callbackTypes;
    private boolean validateCallbackTypes;
    private boolean classOnly;
    private Class<?> superclass;
    private Class<?>[] argumentTypes;
    private Object[] arguments;
    private boolean useFactory = true;
    private Long serialVersionUID;
    private boolean interceptDuringConstruction = true;

    public Enhancer() {
        super("Enhance");
    }

    public Enhancer setSuperclass(Class<?> superclass) {
        if (superclass != null && superclass.isInterface()) {
            this.setInterfaces(superclass);
        } else {
            this.superclass = superclass != null && superclass.equals(Object.class) ? null : superclass;
        }
        return this;
    }

    public Enhancer setInterfaces(Class<?> ... interfaces) {
        this.interfaces = interfaces;
        return this;
    }

    public Enhancer setCallbackFilter(CallbackFilter filter) {
        this.filter = filter;
        return this;
    }

    public Enhancer setCallback(Callback callback) {
        this.setCallbacks(callback);
        return this;
    }

    public Enhancer setCallbacks(Callback ... callbacks) {
        if (ObjectUtils.isEmpty(callbacks)) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbacks = callbacks;
        return this;
    }

    public Enhancer setUseFactory(boolean useFactory) {
        this.useFactory = useFactory;
        return this;
    }

    public Enhancer setInterceptDuringConstruction(boolean interceptDuringConstruction) {
        this.interceptDuringConstruction = interceptDuringConstruction;
        return this;
    }

    public Enhancer setCallbackType(Class<?> callbackType) {
        this.setCallbackTypes(callbackType);
        return this;
    }

    public Enhancer setCallbackTypes(Class<?> ... callbackTypes) {
        if (ObjectUtils.isEmpty(callbackTypes)) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbackTypes = CallbackInfo.determineTypes(callbackTypes);
        return this;
    }

    @Override
    public Enhancer setUseCache(boolean useCache) {
        super.setUseCache(useCache);
        return this;
    }

    @Override
    public Enhancer setAttemptLoad(boolean attemptLoad) {
        super.setAttemptLoad(attemptLoad);
        return this;
    }

    @Override
    public Enhancer setClassLoader(ClassLoader classLoader) {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public Enhancer setNamingPolicy(NamingPolicy namingPolicy) {
        super.setNamingPolicy(namingPolicy);
        return this;
    }

    @Override
    public Enhancer setStrategy(GeneratorStrategy strategy) {
        super.setStrategy(strategy);
        return this;
    }

    public Object create() {
        this.classOnly = false;
        this.argumentTypes = null;
        return this.createHelper();
    }

    public Object create(Class<?>[] argumentTypes, Object[] arguments) {
        this.classOnly = false;
        if (argumentTypes == null || arguments == null || argumentTypes.length != arguments.length) {
            throw new IllegalArgumentException("Arguments must be non-null and of equal length");
        }
        this.argumentTypes = argumentTypes;
        this.arguments = arguments;
        return this.createHelper();
    }

    public Class<?> createClass() {
        this.classOnly = true;
        return (Class)this.createHelper();
    }

    public Enhancer setSerialVersionUID(Long sUID) {
        this.serialVersionUID = sUID;
        return this;
    }

    private void preValidate() {
        if (this.callbackTypes == null) {
            this.callbackTypes = CallbackInfo.determineTypes(this.callbacks, false);
            this.validateCallbackTypes = true;
        }
        if (this.filter == null) {
            if (this.callbackTypes.length > 1) {
                throw new IllegalStateException("Multiple callback types possible but no filter specified");
            }
            this.filter = ALL_ZERO;
        }
    }

    private void validate() {
        if (this.classOnly ^ this.callbacks == null) {
            if (this.classOnly) {
                throw new IllegalStateException("createClass does not accept callbacks");
            }
            throw new IllegalStateException("Callbacks are required");
        }
        if (this.classOnly && this.callbackTypes == null) {
            throw new IllegalStateException("Callback types are required");
        }
        if (this.validateCallbackTypes) {
            this.callbackTypes = null;
        }
        if (this.callbacks != null && this.callbackTypes != null) {
            if (this.callbacks.length != this.callbackTypes.length) {
                throw new IllegalStateException("Lengths of callback and callback types array must be the same");
            }
            Type[] check = CallbackInfo.determineTypes(this.callbacks);
            for (int i = 0; i < check.length; ++i) {
                if (check[i].equals(this.callbackTypes[i])) continue;
                throw new IllegalStateException("Callback " + check[i] + " is not assignable to " + this.callbackTypes[i]);
            }
        } else if (this.callbacks != null) {
            this.callbackTypes = CallbackInfo.determineTypes(this.callbacks);
        }
        if (this.interfaces != null) {
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (this.interfaces[i] == null) {
                    throw new IllegalStateException("Interfaces cannot be null");
                }
                if (this.interfaces[i].isInterface()) continue;
                throw new IllegalStateException(this.interfaces[i] + " is not an interface");
            }
        }
    }

    private Object createHelper() {
        Object key;
        this.preValidate();
        this.currentKey = key = KEY_FACTORY.newInstance(this.superclass != null ? this.superclass.getName() : null, CglibReflectUtils.getNames(this.interfaces), this.filter == ALL_ZERO ? null : new WeakCacheKey<CallbackFilter>(this.filter), this.callbackTypes, this.useFactory, this.interceptDuringConstruction, this.serialVersionUID);
        return super.create(key);
    }

    @Override
    protected Class<?> generate(AbstractClassGenerator.ClassLoaderData data) {
        this.validate();
        if (this.superclass != null) {
            this.setNamePrefix(this.superclass.getName());
        } else if (this.interfaces != null) {
            this.setNamePrefix(this.interfaces[CglibReflectUtils.findPackageProtected(this.interfaces)].getName());
        }
        return super.generate(data);
    }

    @Override
    protected ClassLoader getDefaultClassLoader() {
        if (this.superclass != null) {
            return this.superclass.getClassLoader();
        }
        if (ObjectUtils.isNotEmpty(this.interfaces)) {
            return this.interfaces[0].getClassLoader();
        }
        return null;
    }

    @Override
    protected ProtectionDomain getProtectionDomain() {
        if (this.superclass != null) {
            return CglibReflectUtils.getProtectionDomain(this.superclass);
        }
        if (ObjectUtils.isNotEmpty(this.interfaces)) {
            return CglibReflectUtils.getProtectionDomain(this.interfaces[0]);
        }
        return null;
    }

    private Signature rename(Signature sig, int index) {
        return new Signature("TODAY$" + sig.getName() + '$' + index, sig.getDescriptor());
    }

    public static void getMethods(Class<?> superclass, Class<?>[] interfaces, List<Method> methods) {
        Enhancer.getMethods(superclass, interfaces, methods, null, null);
    }

    private static void getMethods(Class<?> superclass, Class<?>[] interfaces, List<Method> methods, List<Method> interfaceMethods, Set<Object> forcePublic) {
        List<Method> target;
        CglibReflectUtils.addAllMethods(superclass, methods);
        List<Method> list = target = interfaceMethods != null ? interfaceMethods : methods;
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i] == Factory.class) continue;
                CglibReflectUtils.addAllMethods(interfaces[i], target);
            }
        }
        if (interfaceMethods != null) {
            if (forcePublic != null) {
                forcePublic.addAll(MethodWrapper.createSet(interfaceMethods));
            }
            methods.addAll(interfaceMethods);
        }
        CglibCollectionUtils.filter(methods, new RejectModifierPredicate(8));
        CglibCollectionUtils.filter(methods, new VisibilityPredicate(superclass, true));
        CglibCollectionUtils.filter(methods, new DuplicatesPredicate(methods));
        CglibCollectionUtils.filter(methods, new RejectModifierPredicate(16));
    }

    @Override
    public void generateClass(ClassVisitor v) throws Exception {
        Class sc;
        Class clazz = sc = this.superclass == null ? Object.class : this.superclass;
        if (Modifier.isFinal(sc.getModifiers())) {
            throw new IllegalArgumentException("Cannot subclass final class " + sc.getName());
        }
        ArrayList constructors = new ArrayList(8);
        Collections.addAll(constructors, sc.getDeclaredConstructors());
        this.filterConstructors(sc, constructors);
        ArrayList<Method> actualMethods = new ArrayList<Method>();
        ArrayList<Method> interfaceMethods = new ArrayList<Method>();
        HashSet<Object> forcePublic = new HashSet<Object>();
        Enhancer.getMethods(sc, this.interfaces, actualMethods, interfaceMethods, forcePublic);
        List<MethodInfo> methods = CglibCollectionUtils.transform(actualMethods, method -> {
            int modifiers = 0x10 | method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFDF;
            if (forcePublic.contains(MethodWrapper.create(method))) {
                modifiers = modifiers & 0xFFFFFFFB | 1;
            }
            return CglibReflectUtils.getMethodInfo(method, modifiers);
        });
        ClassEmitter e = new ClassEmitter(v);
        if (this.currentData == null) {
            e.beginClass(52, 1, this.getClassName(), Type.getType(sc), this.useFactory ? TypeUtils.add(TypeUtils.getTypes(this.interfaces), FACTORY) : TypeUtils.getTypes(this.interfaces), "<cglibGenerated>");
        } else {
            e.beginClass(52, 1, this.getClassName(), null, Type.array(FACTORY), "<cglibGenerated>");
        }
        List<MethodInfo> constructorInfo = CglibCollectionUtils.transform(constructors, MethodInfoTransformer.getInstance());
        e.declare_field(2, BOUND_FIELD, Type.BOOLEAN_TYPE, null);
        e.declare_field(9, FACTORY_DATA_FIELD, OBJECT_TYPE, null);
        if (!this.interceptDuringConstruction) {
            e.declare_field(2, CONSTRUCTED_FIELD, Type.BOOLEAN_TYPE, null);
        }
        e.declare_field(26, THREAD_CALLBACKS_FIELD, THREAD_LOCAL, null);
        e.declare_field(26, STATIC_CALLBACKS_FIELD, CALLBACK_ARRAY, null);
        if (this.serialVersionUID != null) {
            e.declare_field(26, "serialVersionUID", Type.LONG_TYPE, this.serialVersionUID);
        }
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            e.declare_field(2, Enhancer.getCallbackField(i), this.callbackTypes[i], null);
        }
        e.declare_field(10, CALLBACK_FILTER_FIELD, OBJECT_TYPE, null);
        if (this.currentData == null) {
            this.emitMethods(e, methods, actualMethods);
            this.emitConstructors(e, constructorInfo);
        } else {
            this.emitDefaultConstructor(e);
        }
        this.emitSetThreadCallbacks(e);
        this.emitSetStaticCallbacks(e);
        this.emitBindCallbacks(e);
        if (this.useFactory || this.currentData != null) {
            int[] keys = this.getCallbackKeys();
            this.emitNewInstanceCallbacks(e);
            this.emitNewInstanceCallback(e);
            this.emitNewInstanceMultiarg(e, constructorInfo);
            this.emitGetCallback(e, keys);
            this.emitSetCallback(e, keys);
            this.emitGetCallbacks(e);
            this.emitSetCallbacks(e);
        }
        e.endClass();
    }

    protected void filterConstructors(Class sc, List constructors) {
        CglibCollectionUtils.filter(constructors, new VisibilityPredicate(sc, true));
        if (constructors.size() == 0) {
            throw new IllegalArgumentException("No visible constructors in " + sc);
        }
    }

    @Override
    protected Object firstInstance(Class type) throws Exception {
        if (this.classOnly) {
            return type;
        }
        return this.createUsingReflection(type);
    }

    @Override
    protected Object nextInstance(Object instance) {
        EnhancerFactoryData data = (EnhancerFactoryData)instance;
        if (this.classOnly) {
            return data.generatedClass;
        }
        Class<?>[] argumentTypes = this.argumentTypes;
        Object[] arguments = this.arguments;
        if (argumentTypes == null) {
            argumentTypes = Constant.EMPTY_CLASS_ARRAY;
            arguments = null;
        }
        return data.newInstance(argumentTypes, arguments, this.callbacks);
    }

    @Override
    protected Object wrapCachedClass(Class klass) {
        Class<?>[] argumentTypes = this.argumentTypes;
        if (argumentTypes == null) {
            argumentTypes = Constant.EMPTY_CLASS_ARRAY;
        }
        EnhancerFactoryData factoryData = new EnhancerFactoryData(klass, argumentTypes, this.classOnly);
        Field factoryDataField = null;
        try {
            factoryDataField = klass.getField(FACTORY_DATA_FIELD);
            factoryDataField.set(null, factoryData);
            Field callbackFilterField = klass.getDeclaredField(CALLBACK_FILTER_FIELD);
            callbackFilterField.setAccessible(true);
            callbackFilterField.set(null, this.filter);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new CodeGenerationException(e);
        }
        return new WeakReference<EnhancerFactoryData>(factoryData);
    }

    @Override
    protected Object unwrapCachedValue(Object cached) {
        if (this.currentKey instanceof EnhancerKey) {
            EnhancerFactoryData data = (EnhancerFactoryData)((WeakReference)cached).get();
            return data;
        }
        return super.unwrapCachedValue(cached);
    }

    public static void registerCallbacks(Class generatedClass, Callback[] callbacks) {
        Enhancer.setThreadCallbacks(generatedClass, callbacks);
    }

    public static void registerStaticCallbacks(Class generatedClass, Callback[] callbacks) {
        Enhancer.setCallbacksHelper(generatedClass, callbacks, SET_STATIC_CALLBACKS_NAME);
    }

    public static boolean isEnhanced(Class type) {
        try {
            Enhancer.getCallbacksSetter(type, SET_THREAD_CALLBACKS_NAME);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static void setThreadCallbacks(Class type, Callback[] callbacks) {
        Enhancer.setCallbacksHelper(type, callbacks, SET_THREAD_CALLBACKS_NAME);
    }

    private static void setCallbacksHelper(Class type, Callback[] callbacks, String methodName) {
        try {
            Enhancer.getCallbacksSetter(type, methodName).invoke(null, new Object[]{callbacks});
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(type + " is not an enhanced class");
        }
        catch (IllegalAccessException e) {
            throw new CodeGenerationException(e);
        }
        catch (InvocationTargetException e) {
            throw new CodeGenerationException(e.getTargetException());
        }
    }

    private static Method getCallbacksSetter(Class type, String methodName) throws NoSuchMethodException {
        return type.getDeclaredMethod(methodName, Callback[].class);
    }

    private Object createUsingReflection(Class type) {
        Enhancer.setThreadCallbacks(type, this.callbacks);
        try {
            if (this.argumentTypes != null) {
                Object t = CglibReflectUtils.newInstance(type, this.argumentTypes, this.arguments);
                return t;
            }
            Object t = CglibReflectUtils.newInstance(type);
            return t;
        }
        finally {
            Enhancer.setThreadCallbacks(type, null);
        }
    }

    public static Object create(Class type, Callback callback) {
        Enhancer e = new Enhancer();
        e.setSuperclass(type);
        e.setCallback(callback);
        return e.create();
    }

    public static Object create(Class superclass, Class[] interfaces, Callback callback) {
        Enhancer e = new Enhancer();
        e.setSuperclass(superclass);
        e.setInterfaces(interfaces);
        e.setCallback(callback);
        return e.create();
    }

    public static Object create(Class superclass, Class[] interfaces, CallbackFilter filter, Callback[] callbacks) {
        Enhancer e = new Enhancer();
        e.setSuperclass(superclass);
        e.setInterfaces(interfaces);
        e.setCallbackFilter(filter);
        e.setCallbacks(callbacks);
        return e.create();
    }

    private void emitDefaultConstructor(ClassEmitter ce) {
        Constructor declaredConstructor;
        try {
            declaredConstructor = Object.class.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Object should have default constructor ", e);
        }
        MethodInfo constructor = MethodInfoTransformer.getInstance().transform(declaredConstructor);
        CodeEmitter e = EmitUtils.beginMethod(ce, constructor, 1);
        e.load_this();
        e.dup();
        Signature sig = constructor.getSignature();
        e.super_invoke_constructor(sig);
        e.return_value();
        e.end_method();
    }

    private void emitConstructors(ClassEmitter ce, List<MethodInfo> constructors) {
        boolean seenNull = false;
        for (MethodInfo constructor : constructors) {
            if (this.currentData != null && !"()V".equals(constructor.getSignature().getDescriptor())) continue;
            CodeEmitter e = EmitUtils.beginMethod(ce, constructor, 1);
            e.load_this();
            e.dup();
            e.load_args();
            Signature sig = constructor.getSignature();
            seenNull = seenNull || sig.getDescriptor().equals("()V");
            e.super_invoke_constructor(sig);
            if (this.currentData == null) {
                e.invoke_static_this(BIND_CALLBACKS);
                if (!this.interceptDuringConstruction) {
                    e.load_this();
                    e.push(1);
                    e.putfield(CONSTRUCTED_FIELD);
                }
            }
            e.return_value();
            e.end_method();
        }
        if (!this.classOnly && !seenNull && this.arguments == null) {
            throw new IllegalArgumentException("Superclass has no null constructors but no arguments were given");
        }
    }

    private int[] getCallbackKeys() {
        int[] keys = new int[this.callbackTypes.length];
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            keys[i] = i;
        }
        return keys;
    }

    private void emitGetCallback(ClassEmitter ce, int[] keys) {
        final CodeEmitter e = ce.beginMethod(1, GET_CALLBACK, new Type[0]);
        e.load_this();
        e.invoke_static_this(BIND_CALLBACKS);
        e.load_this();
        e.load_arg(0);
        e.process_switch(keys, new ProcessSwitchCallback(){

            @Override
            public void processCase(int key, Label end) {
                e.getfield(Enhancer.getCallbackField(key));
                e.goTo(end);
            }

            @Override
            public void processDefault() {
                e.pop();
                e.aconst_null();
            }
        });
        e.return_value();
        e.end_method();
    }

    private void emitSetCallback(ClassEmitter ce, int[] keys) {
        final CodeEmitter e = ce.beginMethod(1, SET_CALLBACK, new Type[0]);
        e.load_arg(0);
        e.process_switch(keys, new ProcessSwitchCallback(){

            @Override
            public void processCase(int key, Label end) {
                e.load_this();
                e.load_arg(1);
                e.checkcast(Enhancer.this.callbackTypes[key]);
                e.putfield(Enhancer.getCallbackField(key));
                e.goTo(end);
            }

            @Override
            public void processDefault() {
            }
        });
        e.return_value();
        e.end_method();
    }

    private void emitSetCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.beginMethod(1, SET_CALLBACKS, new Type[0]);
        e.load_this();
        e.load_arg(0);
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            e.dup2();
            e.aaload(i);
            e.checkcast(this.callbackTypes[i]);
            e.putfield(Enhancer.getCallbackField(i));
        }
        e.return_value();
        e.end_method();
    }

    private void emitGetCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.beginMethod(1, GET_CALLBACKS, new Type[0]);
        e.load_this();
        e.invoke_static_this(BIND_CALLBACKS);
        e.load_this();
        e.push(this.callbackTypes.length);
        e.newArray(CALLBACK);
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            e.dup();
            e.push(i);
            e.load_this();
            e.getfield(Enhancer.getCallbackField(i));
            e.aastore();
        }
        e.return_value();
        e.end_method();
    }

    private void emitNewInstanceCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.beginMethod(1, NEW_INSTANCE, new Type[0]);
        Type thisType = this.getThisType(e);
        e.load_arg(0);
        e.invoke_static(thisType, SET_THREAD_CALLBACKS);
        this.emitCommonNewInstance(e);
    }

    private Type getThisType(CodeEmitter e) {
        if (this.currentData == null) {
            return e.getClassEmitter().getClassType();
        }
        return Type.getType(this.currentData.generatedClass);
    }

    private void emitCommonNewInstance(CodeEmitter e) {
        Type thisType = this.getThisType(e);
        e.new_instance(thisType);
        e.dup();
        e.invoke_constructor(thisType);
        e.aconst_null();
        e.invoke_static(thisType, SET_THREAD_CALLBACKS);
        e.return_value();
        e.end_method();
    }

    private void emitNewInstanceCallback(ClassEmitter ce) {
        CodeEmitter e = ce.beginMethod(1, SINGLE_NEW_INSTANCE, new Type[0]);
        switch (this.callbackTypes.length) {
            case 0: {
                break;
            }
            case 1: {
                e.push(1);
                e.newArray(CALLBACK);
                e.dup();
                e.push(0);
                e.load_arg(0);
                e.aastore();
                e.invoke_static(this.getThisType(e), SET_THREAD_CALLBACKS);
                break;
            }
            default: {
                e.throw_exception(ILLEGAL_STATE_EXCEPTION, "More than one callback object required");
            }
        }
        this.emitCommonNewInstance(e);
    }

    private void emitNewInstanceMultiarg(ClassEmitter ce, List constructors) {
        final CodeEmitter e = ce.beginMethod(1, MULTIARG_NEW_INSTANCE, new Type[0]);
        final Type thisType = this.getThisType(e);
        e.load_arg(2);
        e.invoke_static(thisType, SET_THREAD_CALLBACKS);
        e.new_instance(thisType);
        e.dup();
        e.load_arg(0);
        EmitUtils.constructorSwitch(e, constructors, new ObjectSwitchCallback(){

            @Override
            public void processCase(Object key, Label end) {
                MethodInfo constructor = (MethodInfo)key;
                Type[] types = constructor.getSignature().getArgumentTypes();
                for (int i = 0; i < types.length; ++i) {
                    e.load_arg(1);
                    e.push(i);
                    e.aaload();
                    e.unbox(types[i]);
                }
                e.invoke_constructor(thisType, constructor.getSignature());
                e.goTo(end);
            }

            @Override
            public void processDefault() {
                e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Constructor not found");
            }
        });
        e.aconst_null();
        e.invoke_static(thisType, SET_THREAD_CALLBACKS);
        e.return_value();
        e.end_method();
    }

    private void emitMethods(ClassEmitter ce, List<MethodInfo> methods, List<Method> actualMethods) {
        Iterator<Method> it2;
        Type[] callbackTypes = this.callbackTypes;
        CallbackGenerator[] generators = CallbackInfo.getGenerators(callbackTypes);
        HashMap<CallbackGenerator, ArrayList<MethodInfo>> groups = new HashMap<CallbackGenerator, ArrayList<MethodInfo>>();
        final HashMap<MethodInfo, Integer> indexes = new HashMap<MethodInfo, Integer>();
        final HashMap<MethodInfo, Integer> originalModifiers = new HashMap<MethodInfo, Integer>();
        final Map<MethodInfo, Integer> positions = CglibCollectionUtils.getIndexMap(methods);
        HashMap declToBridge = new HashMap();
        Iterator<MethodInfo> it1 = methods.iterator();
        Iterator<Method> iterator = it2 = actualMethods != null ? actualMethods.iterator() : null;
        while (it1.hasNext()) {
            MethodInfo method = it1.next();
            Method actualMethod = it2 != null ? it2.next() : null;
            int index = this.filter.accept(actualMethod);
            if (index >= callbackTypes.length) {
                throw new IllegalArgumentException("Callback filter returned an index that is too large: " + index);
            }
            originalModifiers.put(method, actualMethod != null ? actualMethod.getModifiers() : method.getModifiers());
            indexes.put(method, index);
            ArrayList<MethodInfo> group = (ArrayList<MethodInfo>)groups.get(generators[index]);
            if (group == null) {
                group = new ArrayList<MethodInfo>(methods.size());
                groups.put(generators[index], group);
            }
            group.add(method);
            if (!actualMethod.isBridge()) continue;
            HashSet<Signature> bridges = (HashSet<Signature>)declToBridge.get(actualMethod.getDeclaringClass());
            if (bridges == null) {
                bridges = new HashSet<Signature>();
                declToBridge.put(actualMethod.getDeclaringClass(), bridges);
            }
            bridges.add(method.getSignature());
        }
        final Map<Signature, Signature> bridgeToTarget = BridgeMethodResolver.resolve(this.getClassLoader(), declToBridge);
        HashSet<CallbackGenerator> seenGen = new HashSet<CallbackGenerator>();
        CodeEmitter se = ce.getStaticHook();
        se.new_instance(THREAD_LOCAL);
        se.dup();
        se.invoke_constructor(THREAD_LOCAL, CSTRUCT_NULL);
        se.putfield(THREAD_CALLBACKS_FIELD);
        CallbackGenerator.Context context = new CallbackGenerator.Context(){

            @Override
            public ClassLoader getClassLoader() {
                return Enhancer.this.getClassLoader();
            }

            @Override
            public int getOriginalModifiers(MethodInfo method) {
                return (Integer)originalModifiers.get(method);
            }

            @Override
            public int getIndex(MethodInfo method) {
                return (Integer)indexes.get(method);
            }

            @Override
            public void emitCallback(CodeEmitter e, int index) {
                Enhancer.this.emitCurrentCallback(e, index);
            }

            @Override
            public Signature getImplSignature(MethodInfo method) {
                return Enhancer.this.rename(method.getSignature(), (Integer)positions.get(method));
            }

            @Override
            public void emitLoadArgsAndInvoke(CodeEmitter e, MethodInfo method) {
                Signature bridgeTarget = (Signature)bridgeToTarget.get(method.getSignature());
                if (bridgeTarget != null) {
                    Type[] argumentTypes = bridgeTarget.getArgumentTypes();
                    for (int i = 0; i < argumentTypes.length; ++i) {
                        e.load_arg(i);
                        Type target = argumentTypes[i];
                        if (target.equals(method.getSignature().getArgumentTypes()[i])) continue;
                        e.checkcast(target);
                    }
                    e.invoke_virtual_this(bridgeTarget);
                    Type retType = method.getSignature().getReturnType();
                    if (!retType.equals(bridgeTarget.getReturnType())) {
                        e.checkcast(retType);
                    }
                } else {
                    e.load_args();
                    e.super_invoke(method.getSignature());
                }
            }

            @Override
            public CodeEmitter beginMethod(ClassEmitter ce, MethodInfo method) {
                CodeEmitter e = EmitUtils.beginMethod(ce, method);
                if (!Enhancer.this.interceptDuringConstruction && !Modifier.isAbstract(method.getModifiers())) {
                    Label constructed = e.make_label();
                    e.load_this();
                    e.getfield(Enhancer.CONSTRUCTED_FIELD);
                    e.if_jump(154, constructed);
                    e.load_this();
                    e.load_args();
                    e.super_invoke();
                    e.return_value();
                    e.mark(constructed);
                }
                return e;
            }
        };
        for (int i = 0; i < callbackTypes.length; ++i) {
            CallbackGenerator gen = generators[i];
            if (seenGen.contains(gen)) continue;
            seenGen.add(gen);
            List fmethods = (List)groups.get(gen);
            if (fmethods == null) continue;
            try {
                gen.generate(ce, context, fmethods);
                gen.generateStatic(se, context, fmethods);
                continue;
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw new CodeGenerationException(x);
            }
        }
        se.return_value();
        se.end_method();
    }

    private void emitSetThreadCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.beginMethod(9, SET_THREAD_CALLBACKS, new Type[0]);
        e.getfield(THREAD_CALLBACKS_FIELD);
        e.load_arg(0);
        e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
        e.return_value();
        e.end_method();
    }

    private void emitSetStaticCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.beginMethod(9, SET_STATIC_CALLBACKS, new Type[0]);
        e.load_arg(0);
        e.putfield(STATIC_CALLBACKS_FIELD);
        e.return_value();
        e.end_method();
    }

    private void emitCurrentCallback(CodeEmitter e, int index) {
        e.load_this();
        e.getfield(Enhancer.getCallbackField(index));
        e.dup();
        Label end = e.make_label();
        e.ifnonnull(end);
        e.pop();
        e.load_this();
        e.invoke_static_this(BIND_CALLBACKS);
        e.load_this();
        e.getfield(Enhancer.getCallbackField(index));
        e.mark(end);
    }

    private void emitBindCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.beginMethod(26, BIND_CALLBACKS, new Type[0]);
        Local me = e.make_local();
        e.load_arg(0);
        e.checkcast_this();
        e.store_local(me);
        Label end = e.make_label();
        e.load_local(me);
        e.getfield(BOUND_FIELD);
        e.if_jump(154, end);
        e.load_local(me);
        e.push(1);
        e.putfield(BOUND_FIELD);
        e.getfield(THREAD_CALLBACKS_FIELD);
        e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_GET);
        e.dup();
        Label found_callback = e.make_label();
        e.ifnonnull(found_callback);
        e.pop();
        e.getfield(STATIC_CALLBACKS_FIELD);
        e.dup();
        e.ifnonnull(found_callback);
        e.pop();
        e.goTo(end);
        e.mark(found_callback);
        e.checkcast(CALLBACK_ARRAY);
        e.load_local(me);
        e.swap();
        for (int i = this.callbackTypes.length - 1; i >= 0; --i) {
            if (i != 0) {
                e.dup2();
            }
            e.aaload(i);
            e.checkcast(this.callbackTypes[i]);
            e.putfield(Enhancer.getCallbackField(i));
        }
        e.mark(end);
        e.return_value();
        e.end_method();
    }

    private static String getCallbackField(int index) {
        return "TODAY$CALLBACK_" + index;
    }

    protected static class BridgeMethodResolver {
        protected BridgeMethodResolver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Map<Signature, Signature> resolve(ClassLoader classLoader, Map<Class<?>, Set<Signature>> declToBridge) {
            HashMap<Signature, Signature> resolved = new HashMap<Signature, Signature>();
            for (Map.Entry<Class<?>, Set<Signature>> entry : declToBridge.entrySet()) {
                try {
                    InputStream is = classLoader.getResourceAsStream(entry.getKey().getName().replace('.', '/') + ".class");
                    if (is == null) {
                        return resolved;
                    }
                    try {
                        new ClassReader(is).accept(new BridgedFinder(entry.getValue(), resolved), 6);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return resolved;
        }

        private static class BridgedFinder
        extends ClassVisitor {
            private Signature currentMethod = null;
            private final Set<Signature> eligibleMethods;
            private final Map<Signature, Signature> resolved;

            BridgedFinder(Set<Signature> eligibleMethods, Map<Signature, Signature> resolved) {
                this.resolved = resolved;
                this.eligibleMethods = eligibleMethods;
            }

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                Signature sig = new Signature(name, desc);
                if (!this.eligibleMethods.remove(sig)) {
                    return null;
                }
                this.currentMethod = sig;
                return new MethodVisitor(){

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        if ((opcode == 183 || itf && opcode == 185) && currentMethod != null) {
                            Signature target = new Signature(name, desc);
                            if (!target.equals(currentMethod)) {
                                resolved.put(currentMethod, target);
                            }
                            currentMethod = null;
                        }
                    }
                };
            }
        }
    }

    static class EnhancerFactoryData {
        public final Class<?> generatedClass;
        private final Method setThreadCallbacks;
        private final Class<?>[] primaryConstructorArgTypes;
        private final Constructor<?> primaryConstructor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object newInstance(Class<?>[] argumentTypes, Object[] arguments, Callback[] callbacks) {
            this.setThreadCallbacks(callbacks);
            try {
                if (this.primaryConstructorArgTypes == argumentTypes || Arrays.equals(this.primaryConstructorArgTypes, argumentTypes)) {
                    Object obj = CglibReflectUtils.newInstance(this.primaryConstructor, arguments);
                    return obj;
                }
                Object obj = CglibReflectUtils.newInstance(this.generatedClass, argumentTypes, arguments);
                return obj;
            }
            finally {
                this.setThreadCallbacks(null);
            }
        }

        public EnhancerFactoryData(Class<?> generatedClass, Class<?>[] primaryConstructorArgTypes, boolean classOnly) {
            this.generatedClass = generatedClass;
            try {
                this.setThreadCallbacks = Enhancer.getCallbacksSetter(generatedClass, Enhancer.SET_THREAD_CALLBACKS_NAME);
                if (classOnly) {
                    this.primaryConstructorArgTypes = null;
                    this.primaryConstructor = null;
                } else {
                    this.primaryConstructorArgTypes = primaryConstructorArgTypes;
                    this.primaryConstructor = CglibReflectUtils.getConstructor(generatedClass, primaryConstructorArgTypes);
                }
            }
            catch (NoSuchMethodException e) {
                throw new CodeGenerationException(e);
            }
        }

        private void setThreadCallbacks(Callback[] callbacks) {
            try {
                this.setThreadCallbacks.invoke(this.generatedClass, new Object[]{callbacks});
            }
            catch (IllegalAccessException e) {
                throw new CodeGenerationException(e);
            }
            catch (InvocationTargetException e) {
                throw new CodeGenerationException(e.getTargetException());
            }
        }
    }

    public static interface EnhancerKey {
        public Object newInstance(String var1, String[] var2, WeakCacheKey<CallbackFilter> var3, Type[] var4, boolean var5, boolean var6, Long var7);
    }
}

