/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.proxy;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.Label;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.TypeUtils;
import cn.taketoday.context.cglib.proxy.CallbackGenerator;
import cn.taketoday.context.cglib.proxy.LazyLoader;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class LazyLoaderGenerator
implements CallbackGenerator {
    public static final LazyLoaderGenerator INSTANCE = new LazyLoaderGenerator();
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");
    private static final Type LAZY_LOADER = TypeUtils.parseType(LazyLoader.class);

    LazyLoaderGenerator() {
    }

    @Override
    public void generate(ClassEmitter ce, CallbackGenerator.Context context, List<MethodInfo> methods) {
        CodeEmitter e;
        HashSet<Integer> indexes = new HashSet<Integer>();
        for (MethodInfo method : methods) {
            if (Modifier.isProtected(method.getModifiers())) continue;
            int index = context.getIndex(method);
            indexes.add(index);
            e = context.beginMethod(ce, method);
            e.load_this();
            e.dup();
            e.invoke_virtual_this(this.loadMethod(index));
            e.checkcast(method.getClassInfo().getType());
            e.load_args();
            e.invoke(method);
            e.return_value();
            e.end_method();
        }
        Iterator<MethodInfo> iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)((Object)iterator.next());
            String delegate = "TODAY$LAZY_LOADER_" + index;
            ce.declare_field(2, delegate, Constant.TYPE_OBJECT, null);
            e = ce.beginMethod(50, this.loadMethod(index), new Type[0]);
            e.load_this();
            e.getfield(delegate);
            e.dup();
            Label end = e.make_label();
            e.ifnonnull(end);
            e.pop();
            e.load_this();
            context.emitCallback(e, index);
            e.invoke_interface(LAZY_LOADER, LOAD_OBJECT);
            e.dup_x1();
            e.putfield(delegate);
            e.mark(end);
            e.return_value();
            e.end_method();
        }
    }

    private Signature loadMethod(int index) {
        return new Signature("TODAY$LOAD_PRIVATE_" + index, Constant.TYPE_OBJECT, Constant.TYPES_EMPTY_ARRAY);
    }

    @Override
    public void generateStatic(CodeEmitter e, CallbackGenerator.Context context, List<MethodInfo> methods) {
    }
}

