/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.proxy;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.Label;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.CglibCollectionUtils;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.ClassInfo;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.Local;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.ObjectSwitchCallback;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.Transformer;
import cn.taketoday.context.cglib.core.TypeUtils;
import cn.taketoday.context.cglib.proxy.CallbackGenerator;
import cn.taketoday.context.cglib.proxy.MethodInterceptor;
import cn.taketoday.context.cglib.proxy.MethodProxy;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class MethodInterceptorGenerator
implements CallbackGenerator {
    public static final MethodInterceptorGenerator INSTANCE = new MethodInterceptorGenerator();
    static final String FIND_PROXY_NAME = "TODAY$findMethodProxy";
    static final Class<?>[] FIND_PROXY_TYPES = new Class[]{Signature.class};
    private static final Type METHOD = TypeUtils.parseType(Method.class);
    private static final Type ABSTRACT_METHOD_ERROR = TypeUtils.parseType(AbstractMethodError.class);
    private static final Type REFLECT_UTILS = TypeUtils.parseType(CglibReflectUtils.class);
    private static final Type METHOD_PROXY = TypeUtils.parseType(MethodProxy.class);
    private static final Type METHOD_INTERCEPTOR = TypeUtils.parseType(MethodInterceptor.class);
    private static final Signature GET_DECLARED_METHODS = TypeUtils.parseSignature("java.lang.reflect.Method[] getDeclaredMethods()");
    private static final Signature FIND_METHODS = TypeUtils.parseSignature("java.lang.reflect.Method[] findMethods(String[], java.lang.reflect.Method[])");
    private static final Signature MAKE_PROXY = new Signature("create", METHOD_PROXY, Type.array(Constant.TYPE_CLASS, Constant.TYPE_CLASS, Constant.TYPE_STRING, Constant.TYPE_STRING, Constant.TYPE_STRING));
    private static final Signature INTERCEPT = new Signature("intercept", Constant.TYPE_OBJECT, Type.array(Constant.TYPE_OBJECT, METHOD, Constant.TYPE_OBJECT_ARRAY, METHOD_PROXY));
    private static final Signature FIND_PROXY = new Signature("TODAY$findMethodProxy", METHOD_PROXY, Type.array(Constant.TYPE_SIGNATURE));
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    private static final Transformer<MethodInfo, ClassInfo> METHOD_TO_CLASS = MethodInfo::getClassInfo;

    MethodInterceptorGenerator() {
    }

    private String getMethodField(Signature impl) {
        return impl.getName() + "$Method";
    }

    private String getMethodProxyField(Signature impl) {
        return impl.getName() + "$Proxy";
    }

    @Override
    public void generate(ClassEmitter ce, CallbackGenerator.Context context, List<MethodInfo> methods) {
        HashMap<String, String> sigMap = new HashMap<String, String>();
        for (MethodInfo method : methods) {
            Signature sig = method.getSignature();
            Signature impl = context.getImplSignature(method);
            String methodField = this.getMethodField(impl);
            String methodProxyField = this.getMethodProxyField(impl);
            sigMap.put(sig.toString(), methodProxyField);
            ce.declare_field(26, methodField, METHOD, null);
            ce.declare_field(26, methodProxyField, METHOD_PROXY, null);
            CodeEmitter codeEmitter = ce.beginMethod(16, impl, method.getExceptionTypes());
            MethodInterceptorGenerator.superHelper(codeEmitter, method, context);
            codeEmitter.return_value();
            codeEmitter.end_method();
            codeEmitter = context.beginMethod(ce, method);
            Label nullInterceptor = codeEmitter.make_label();
            context.emitCallback(codeEmitter, context.getIndex(method));
            codeEmitter.dup();
            codeEmitter.ifnull(nullInterceptor);
            codeEmitter.load_this();
            codeEmitter.getfield(methodField);
            if (sig.getArgumentTypes().length == 0) {
                EmitUtils.loadEmptyArguments(codeEmitter);
            } else {
                codeEmitter.create_arg_array();
            }
            codeEmitter.getfield(methodProxyField);
            codeEmitter.invoke_interface(METHOD_INTERCEPTOR, INTERCEPT);
            codeEmitter.unbox_or_zero(sig.getReturnType());
            codeEmitter.return_value();
            codeEmitter.mark(nullInterceptor);
            MethodInterceptorGenerator.superHelper(codeEmitter, method, context);
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
        this.generateFindProxy(ce, sigMap);
    }

    private static void superHelper(CodeEmitter e, MethodInfo method, CallbackGenerator.Context context) {
        if (Modifier.isAbstract(method.getModifiers())) {
            e.throw_exception(ABSTRACT_METHOD_ERROR, method + " is abstract");
        } else {
            e.load_this();
            context.emitLoadArgsAndInvoke(e, method);
        }
    }

    @Override
    public void generateStatic(CodeEmitter e, CallbackGenerator.Context context, List<MethodInfo> methods) throws Exception {
        Local thisClass = e.make_local();
        Local declaringClass = e.make_local();
        EmitUtils.loadClassThis(e);
        e.store_local(thisClass);
        Map<ClassInfo, List<MethodInfo>> methodsByClass = CglibCollectionUtils.bucket(methods, METHOD_TO_CLASS);
        for (Map.Entry<ClassInfo, List<MethodInfo>> entry : methodsByClass.entrySet()) {
            int index;
            ClassInfo classInfo = entry.getKey();
            List<MethodInfo> classMethods = entry.getValue();
            int size = classMethods.size();
            e.push(2 * size);
            e.newArray(Constant.TYPE_STRING);
            for (index = 0; index < size; ++index) {
                Signature sig = classMethods.get(index).getSignature();
                e.dup();
                e.push(2 * index);
                e.push(sig.getName());
                e.aastore();
                e.dup();
                e.push(2 * index + 1);
                e.push(sig.getDescriptor());
                e.aastore();
            }
            EmitUtils.loadClass(e, classInfo.getType());
            e.dup();
            e.store_local(declaringClass);
            e.invoke_virtual(Constant.TYPE_CLASS, GET_DECLARED_METHODS);
            e.invoke_static(REFLECT_UTILS, FIND_METHODS);
            for (index = 0; index < size; ++index) {
                MethodInfo method = classMethods.get(index);
                Signature sig = method.getSignature();
                Signature impl = context.getImplSignature(method);
                e.dup();
                e.push(index);
                e.array_load(METHOD);
                e.putfield(this.getMethodField(impl));
                e.load_local(declaringClass);
                e.load_local(thisClass);
                e.push(sig.getDescriptor());
                e.push(sig.getName());
                e.push(impl.getName());
                e.invoke_static(METHOD_PROXY, MAKE_PROXY);
                e.putfield(this.getMethodProxyField(impl));
            }
            e.pop();
        }
    }

    public void generateFindProxy(ClassEmitter ce, final Map<String, String> sigMap) {
        final CodeEmitter e = ce.beginMethod(9, FIND_PROXY, new Type[0]);
        e.load_arg(0);
        e.invoke_virtual(Constant.TYPE_OBJECT, TO_STRING);
        ObjectSwitchCallback callback = new ObjectSwitchCallback(){

            @Override
            public void processCase(Object key, Label end) {
                e.getfield((String)sigMap.get(key));
                e.return_value();
            }

            @Override
            public void processDefault() {
                e.aconst_null();
                e.return_value();
            }
        };
        EmitUtils.stringSwitch(e, sigMap.keySet().toArray(new String[sigMap.size()]), 1, callback);
        e.end_method();
    }
}

