/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.proxy;

import cn.taketoday.context.cglib.core.CodeGenerationException;
import cn.taketoday.context.cglib.proxy.Callback;
import cn.taketoday.context.cglib.proxy.CallbackFilter;
import cn.taketoday.context.cglib.proxy.Enhancer;
import cn.taketoday.context.cglib.proxy.InvocationHandler;
import cn.taketoday.context.cglib.proxy.NoOp;
import java.io.Serializable;
import java.util.Objects;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final InvocationHandler h;
    private static final CallbackFilter BAD_OBJECT_METHOD_FILTER = method -> {
        String name;
        if ("java.lang.Object".equals(method.getDeclaringClass().getName()) && !(name = method.getName()).equals("hashCode") && !name.equals("equals") && !name.equals("toString")) {
            return 1;
        }
        return 0;
    };

    protected Proxy(InvocationHandler h) {
        this.h = h;
        Enhancer.registerCallbacks(this.getClass(), new Callback[]{h, null});
    }

    public static InvocationHandler getInvocationHandler(Object proxy) {
        if (proxy instanceof ProxyImpl) {
            return ((Proxy)proxy).h;
        }
        throw new IllegalArgumentException("Object is not a proxy");
    }

    public static Class<?> getProxyClass(ClassLoader loader, Class<?> ... interfaces) {
        return new Enhancer().setClassLoader(loader).setInterfaces(interfaces).setSuperclass(ProxyImpl.class).setCallbackTypes(InvocationHandler.class, NoOp.class).setCallbackFilter(BAD_OBJECT_METHOD_FILTER).setUseFactory(false).createClass();
    }

    public static boolean isProxyClass(Class<?> cl) {
        return cl.getSuperclass().equals(ProxyImpl.class);
    }

    public static Object newProxyInstance(ClassLoader loader, Class<?>[] interfaces, InvocationHandler h) {
        try {
            return Proxy.getProxyClass(loader, interfaces).getConstructor(InvocationHandler.class).newInstance(Objects.requireNonNull(h));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    private static class ProxyImpl
    extends Proxy {
        private static final long serialVersionUID = 1L;

        protected ProxyImpl(InvocationHandler h) {
            super(h);
        }
    }
}

