/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.reflect;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.AbstractClassGenerator;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.KeyFactory;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.TypeUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.Objects;

public abstract class MethodDelegate {
    private static final MethodDelegateKey KEY_FACTORY = KeyFactory.create(MethodDelegateKey.class, KeyFactory.CLASS_BY_NAME);
    protected Object target;
    protected String eqMethod;

    public static <T> T createStatic(Class targetClass, String methodName, Class<T> iface) {
        Generator gen = new Generator();
        gen.setTargetClass(targetClass);
        gen.setMethodName(methodName);
        gen.setInterface(iface);
        return (T)gen.create();
    }

    public static <T> T create(Object target, String methodName, Class<T> iface) {
        Generator gen = new Generator();
        gen.setTarget(target);
        gen.setMethodName(methodName);
        gen.setInterface(iface);
        return (T)gen.create();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodDelegate)) {
            return false;
        }
        MethodDelegate that = (MethodDelegate)o;
        return Objects.equals(this.target, that.target) && Objects.equals(this.eqMethod, that.eqMethod);
    }

    public int hashCode() {
        return this.target.hashCode() ^ this.eqMethod.hashCode();
    }

    public Object getTarget() {
        return this.target;
    }

    public abstract MethodDelegate newInstance(Object var1);

    public static class Generator
    extends AbstractClassGenerator {
        private static final Type METHOD_DELEGATE = TypeUtils.parseType(MethodDelegate.class);
        private static final Signature NEW_INSTANCE = new Signature("newInstance", METHOD_DELEGATE, new Type[]{Constant.TYPE_OBJECT});
        private Object target;
        private Class targetClass;
        private String methodName;
        private Class iface;

        public Generator() {
            super(MethodDelegate.class);
        }

        public void setTarget(Object target) {
            this.target = target;
            this.targetClass = target.getClass();
        }

        public void setTargetClass(Class targetClass) {
            this.targetClass = targetClass;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public void setInterface(Class iface) {
            this.iface = iface;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.targetClass.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return CglibReflectUtils.getProtectionDomain(this.targetClass);
        }

        public MethodDelegate create() {
            this.setNamePrefix(this.targetClass.getName());
            Object key = KEY_FACTORY.newInstance(this.targetClass, this.methodName, this.iface);
            return (MethodDelegate)super.create(key);
        }

        protected Object firstInstance(Class type) {
            return ((MethodDelegate)CglibReflectUtils.newInstance(type)).newInstance(this.target);
        }

        @Override
        protected Object nextInstance(Object instance) {
            return ((MethodDelegate)instance).newInstance(this.target);
        }

        @Override
        public void generateClass(ClassVisitor v) throws NoSuchMethodException {
            MethodInfo methodInfo;
            boolean isStatic;
            Method proxy = CglibReflectUtils.findInterfaceMethod(this.iface);
            Method method = this.targetClass.getMethod(this.methodName, proxy.getParameterTypes());
            if (!proxy.getReturnType().isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("incompatible return types");
            }
            if (this.target == null ^ (isStatic = Modifier.isStatic((methodInfo = CglibReflectUtils.getMethodInfo(method)).getModifiers()))) {
                throw new IllegalArgumentException("Static method " + (isStatic ? "not " : "") + "expected");
            }
            ClassEmitter ce = new ClassEmitter(v);
            ce.beginClass(52, 1, this.getClassName(), METHOD_DELEGATE, Type.array(Type.getType(this.iface)), "<cglibGenerated>");
            ce.declare_field(26, "eqMethod", Constant.TYPE_STRING, null);
            EmitUtils.nullConstructor(ce);
            MethodInfo proxied = CglibReflectUtils.getMethodInfo(this.iface.getDeclaredMethods()[0]);
            int modifiers = 1;
            if ((proxied.getModifiers() & 0x80) == 128) {
                modifiers |= 0x80;
            }
            CodeEmitter e = EmitUtils.beginMethod(ce, proxied, modifiers);
            e.load_this();
            e.super_getfield("target", Constant.TYPE_OBJECT);
            e.checkcast(methodInfo.getClassInfo().getType());
            e.load_args();
            e.invoke(methodInfo);
            e.return_value();
            e.end_method();
            e = ce.beginMethod(1, NEW_INSTANCE, new Type[0]);
            e.new_instance_this();
            e.dup();
            e.dup2();
            e.invoke_constructor_this();
            e.getfield("eqMethod");
            e.super_putfield("eqMethod", Constant.TYPE_STRING);
            e.load_arg(0);
            e.super_putfield("target", Constant.TYPE_OBJECT);
            e.return_value();
            e.end_method();
            e = ce.begin_static();
            e.push(methodInfo.getSignature().toString());
            e.putfield("eqMethod");
            e.return_value();
            e.end_method();
            ce.endClass();
        }
    }

    static interface MethodDelegateKey {
        public Object newInstance(Class var1, String var2, Class var3);
    }
}

