/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.transform.impl;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.TypeUtils;
import cn.taketoday.context.cglib.transform.ClassEmitterTransformer;

public class AccessFieldTransformer
extends ClassEmitterTransformer {
    private final Callback callback;

    public AccessFieldTransformer(Callback callback) {
        this.callback = callback;
    }

    @Override
    public void declare_field(int access, String name, Type type, Object value) {
        super.declare_field(access, name, type, value);
        String property = TypeUtils.upperFirst(this.callback.getPropertyName(this.getClassType(), name));
        if (property != null) {
            CodeEmitter e = this.beginMethod(1, new Signature("get" + property, type, Constant.TYPES_EMPTY_ARRAY), new Type[0]);
            e.load_this();
            e.getfield(name);
            e.return_value();
            e.end_method();
            e = this.beginMethod(1, new Signature("set" + property, Type.VOID_TYPE, Type.array(type)), new Type[0]);
            e.load_this();
            e.load_arg(0);
            e.putfield(name);
            e.return_value();
            e.end_method();
        }
    }

    public static interface Callback {
        public String getPropertyName(Type var1, String var2);
    }
}

